<?php
$form_fields = [
    'additional_info' => [
        'title' => $additional_text,
        'type' => 'title',
        'priority' => 1
    ],
    'enabled' => [
        'title' => __('Enable/Disable', 'woocommerce'),
        'type' => 'checkbox',
        'label' => __('Enable Payment system VTB', 'wc-vtbpay'),
        'default' => 'yes',
        'priority' => 2
    ],
    'title' => [
        'title' => __('Title', 'woocommerce'),
        'type' => 'text',
        'description' => __('This controls the title which the user sees during checkout.', 'woocommerce'),
        'default' => __('Payment system VTB', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 3
    ],
    'description' => [
        'title' => __('Customer Message', 'wc-vtbpay'),
        'type' => 'textarea',
        'css' => 'width:500px;',
        'default' => __('Pay with a card of any bank without commission.', 'wc-vtbpay'),
        'description' => __('The message which you want it to appear to the customer in the checkout page.', 'wc-vtbpay'),
        'priority' => 4
    ],
    'client_id' => [
        'title' => __('Client ID', 'wc-vtbpay') . ' <span style="color:red;">*<span/>',
        'type' => 'text',
        'description' => __('Merchant\'s client ID is required to call the API.', 'wc-vtbpay'),
        'placeholder' => __('Enter Client ID', 'wc-vtbpay'),
        'custom_attributes' => ['required' => 'required'],
        'desc_tip' => true,
        'priority' => 5
    ],
    'client_secret' => [
        'title' => __('Client Secret', 'wc-vtbpay') . ' <span style="color:red;">*<span/>',
        'type' => 'text',
        'description' => __('Merchant\'s secret key is required to call the API.', 'wc-vtbpay'),
        'placeholder' => __('Enter Client Secret', 'wc-vtbpay'),
        'custom_attributes' => ['required' => 'required'],
        'desc_tip' => true,
        'priority' => 6
    ],
    'merchant_authorization' => [
        'title' => __('Merchant-Authorization', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('Request header used by the merchant resource for additional authentication when accessing the payment gateway.', 'wc-vtbpay'),
        'placeholder' => __('Enter Merchant-Authorization', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 7
    ],
    'test_mode' => [
        'title' => __('Test mode', 'wc-vtbpay'),
        'type' => 'checkbox',
        'label' => __('Enable test mode', 'wc-vtbpay'),
        'description' => __('In this mode, the payment for the goods is not charged.', 'wc-vtbpay'),
        'default' => 'no',
        'priority' => 8
    ],
    'logging' => [
        'title' => __('Logging', 'wc-vtbpay'),
        'type' => 'checkbox',
        'label' => __('Enable logging', 'wc-vtbpay'),
        'description' => __('Logging is used to debug plugin performance by storing API request data.', 'wc-vtbpay'),
        'default' => 'no',
        'priority' => 9
    ],
    'two_stage' => [
        'title' => __('Two-stage payment', 'wc-vtbpay'),
        'type' => 'checkbox',
        'label' => __('Enable two-stage payment', 'wc-vtbpay'),
        'description' => __('Payment in 2 stages: withholding of funds after payment, then confirmation of debit or cancelation of withholding by the merchant via personal cabinet.', 'wc-vtbpay'),
        'default' => 'no',
        'priority' => 10
    ],
    'transaction_end' => [
        'title' => __('Successful transaction order status', 'wc-vtbpay'),
        'type' => 'select',
        'options' => wc_get_order_statuses(),
        'description' => __('Select the order status to be displayed after successful payment.', 'wc-vtbpay'),
        'default' => 'wc-processing',
        'priority' => 11
    ],
    /**
     * Поля настроек фискализации
     */
    'section_separator' => [
        'title'   => __('Fiscalization settings', 'wc-vtbpay'), // Заголовок разделителя
        'type'    => 'title', // Тип элемента формы (title для разделителя)
        'priority' => 13
    ],
    'enable_fiscal' => [
        'title' => __('Fiscalization', 'wc-vtbpay'),
        'type' => 'checkbox',
        'label' => __('Enable fiscalization', 'wc-vtbpay'),
        'description' => __('Enable and disable fiscalization (check the box to enable fiscalization).', 'wc-vtbpay'),
        'default' => 'no',
        'priority' => 14
    ],
    'ofd_fiscal' => [
        'title' => __('Fiscal data operators', 'wc-vtbpay'),
        'type' => 'select',
        'description' => __('Select a fiscal data operator.', 'wc-vtbpay'),
        'placeholder' => __('Enter fiscal data operator.', 'wc-vtbpay'),
        'options' => [
            '1ofd' => __('First OFD', 'wc-vtbpay'),
            'atol' => __('ATOL FFD 1.2 (v5)', 'wc-vtbpay'),
            'orange_data' => __('Orange Data FFD 1.05', 'wc-vtbpay')
        ],
        'desc_tip' => true,
        'default' => '1ofd',
        'priority' => 15
    ],
    // Настройки фискализации только для АТОЛ
    'test_mode_atol_fiscal' => [
        'title' => __('Test mode ATOL Online', 'wc-vtbpay'),
        'type' => 'checkbox',
        'label' => __('Enable test mode', 'wc-vtbpay'),
        'description' => __('Enabling the ATOL Online test mode.', 'wc-vtbpay'),
        'default' => 'no',
        'priority' => 16
    ],
    'login_atol_fiscal' => [
        'title' => __('Login', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('Login to ATOL Online.', 'wc-vtbpay'),
        'placeholder' => __('Enter login', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 17
    ],
    'pass_atol_fiscal' => [
        'title' => __('Password', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('ATOL Online password.', 'wc-vtbpay'),
        'placeholder' => __('Enter password', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 18
    ],
    'kkt_atol_fiscal' => [
        'title' => __('Group code', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('KKT group identifier in ATOL Online.', 'wc-vtbpay'),
        'placeholder' => __('Enter group code', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 19
    ],
    'inn_atol_fiscal' => [
        'title' => __('TIN', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('TIN of the organization.', 'wc-vtbpay'),
        'placeholder' => __('Enter TIN', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 20
    ],
    'tax_system_atol_fiscal' => [
        'title' => __('Taxation system', 'wc-vtbpay'),
        'type' => 'select',
        'description' => __('Your company\'s taxation system.', 'wc-vtbpay'),
        'placeholder' => __('Enter taxation system.', 'wc-vtbpay'),
        'options' => [
            'osn' => __('General TS', 'wc-vtbpay'),
            'usn_income' => __('Simplified TS (income)', 'wc-vtbpay'),
            'usn_income_outcome' => __('Simplified TS (income minus expenses)', 'wc-vtbpay'),
            'envd' => __('Single tax on imputed income', 'wc-vtbpay'),
            'esn' => __('Single agricultural tax', 'wc-vtbpay'),
            'patent' => __('Patent TS', 'wc-vtbpay')
        ],
        'desc_tip' => true,
        'default' => 'osn',
        'priority' => 21
    ],
    // Настройки фискализации только для Orange Data
    'test_mode_orange_data_fiscal' => [
        'title' => __('Test mode Orange Data', 'wc-vtbpay'),
        'type' => 'checkbox',
        'label' => __('Enable test mode', 'wc-vtbpay'),
        'description' => __('Enabling the Orange Data test mode.', 'wc-vtbpay'),
        'default' => 'no',
        'priority' => 22
    ],
    'signature_key_orange_data_fiscal' => [
        'title' => __('Signature verification key', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('The name of the key that should be used to verify the signature.', 'wc-vtbpay'),
        'placeholder' => __('Enter signature verification key', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 23
    ],
    'private_key_orange_data_fiscal' => [
        'title'       => __('Private key', 'wc-vtbpay'),
        'type'        => 'file',
        'description' => __('The user\'s private key for signing requests.', 'wc-vtbpay'),
        'desc_tip'    => true,
        'priority' => 24
    ],
    'client_key_orange_data_fiscal' => [
        'title'       => __('Client Key', 'wc-vtbpay'),
        'type'        => 'file',
        'description' => __('Client private key for SSL connection.', 'wc-vtbpay'),
        'desc_tip'    => true,
        'priority' => 25
    ],
    'client_crt_orange_data_fiscal' => [
        'title'       => __('Client Certificate', 'wc-vtbpay'),
        'type'        => 'file',
        'description' => __('Client certificate (signed by the private key corresponding to the root certificate client_ca.crt).', 'wc-vtbpay'),
        'desc_tip'    => true,
        'priority' => 26
    ],
    'ca_cert_orange_data_fiscal' => [
        'title'       => __('CA Certificate', 'wc-vtbpay'),
        'type'        => 'file',
        'description' => __('Orangedata root certificate (with public key inside). All certificates of all clients are signed with the private key corresponding to this certificate.', 'wc-vtbpay'),
        'desc_tip'    => true,
        'priority' => 27
    ],
    'cert_password_orange_data_fiscal' => [
        'title' => __('Password certificate', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('SSL certificate password.', 'wc-vtbpay'),
        'placeholder' => __('Enter password certificate', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 28
    ],
    'group_orange_data_fiscal' => [
        'title' => __('Group code', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('A group of devices with which the check will be punched.', 'wc-vtbpay'),
        'placeholder' => __('Enter group code', 'wc-vtbpay'),
        'desc_tip' => true,
        'default' => 'Main',
        'priority' => 29
    ],
    'inn_orange_data_fiscal' => [
        'title' => __('TIN', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __('TIN of the organization.', 'wc-vtbpay'),
        'placeholder' => __('Enter TIN', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 30
    ],
    'tax_system_orange_data_fiscal' => [
        'title' => __('Taxation system', 'wc-vtbpay'),
        'type' => 'select',
        'description' => __('Your company\'s taxation system.', 'wc-vtbpay'),
        'placeholder' => __('Enter taxation system.', 'wc-vtbpay'),
        'options' => [
            '0' => __('General TS', 'wc-vtbpay'),
            '1' => __('Simplified TS (income)', 'wc-vtbpay'),
            '2' => __('Simplified TS (income minus expenses)', 'wc-vtbpay'),
            '3' => __('Single tax on imputed income', 'wc-vtbpay'),
            '4' => __('Single agricultural tax', 'wc-vtbpay'),
            '5' => __('Patent TS', 'wc-vtbpay')
        ],
        'desc_tip' => true,
        'default' => '0',
        'priority' => 31
    ],
    // Общие настройки фискализации
    'email_fiscal' => [
        'title' => __('Email', 'wc-vtbpay'),
        'type' => 'text',
        'description' => __("Email for sending a fiscal receipt if the user's email is not specified.", 'wc-vtbpay'),
        'placeholder' => __('Enter email.', 'wc-vtbpay'),
        'desc_tip' => true,
        'priority' => 32
    ],
    'payment_type_delivery_fiscal' => [
        'title' => __('Calculation method for delivery', 'wc-vtbpay'),
        'type' => 'select',
        'description' => __('Calculation method for the delivery service.', 'wc-vtbpay'),
        'placeholder' => __('Enter calculation method for delivery.', 'wc-vtbpay'),
        'options' => [
            'full_prepayment' => __('Prepayment 100%', 'wc-vtbpay'),
            'prepayment' => __('Prepayment', 'wc-vtbpay'),
            'advance' => __('Advance', 'wc-vtbpay'),
            'full_payment' => __('Full payment', 'wc-vtbpay'),
            'partial_payment' => __('Partial payment and credit', 'wc-vtbpay'),
            'credit' => __('Credit transfer', 'wc-vtbpay'),
            'credit_payment' => __('Credit payment', 'wc-vtbpay')
        ],
        'desc_tip' => true,
        'default' => 'full_prepayment',
        'priority' => 33
    ],
    'section_subtitle_fiscal' => [
        'title'   => __('Default settings for products and services', 'wc-vtbpay'), // Заголовок разделителя
        'type'    => 'title', // Тип элемента формы (title для разделителя)
        'priority' => 34
    ],
    'measure_fiscal' => [
        'title' => __('Units of measurement', 'wc-vtbpay'),
        'type' => 'select',
        'description' => __('Default units of measure (for goods and services that do not have a specified unit of measure).', 'wc-vtbpay'),
        'placeholder' => __('Enter units of measurement.', 'wc-vtbpay'),
        'options' => [
            '0' => __('Applies to items that can be sold by piece or unit', 'wc-vtbpay'),
            '10' => __('Gram', 'wc-vtbpay'),
            '11' => __('Kilogram', 'wc-vtbpay'),
            '12' => __('Ton', 'wc-vtbpay'),
            '20' => __('Centimeter', 'wc-vtbpay'),
            '21' => __('Decimeter', 'wc-vtbpay'),
            '22' => __('Meter', 'wc-vtbpay'),
            '30' => __('Square centimeter', 'wc-vtbpay'),
            '31' => __('Square decimeter', 'wc-vtbpay'),
            '32' => __('Square meter', 'wc-vtbpay'),
            '40' => __('Milliliter', 'wc-vtbpay'),
            '41' => __('Liter', 'wc-vtbpay'),
            '42' => __('Cubic meter', 'wc-vtbpay'),
            '50' => __('Kilowatt hour', 'wc-vtbpay'),
            '51' => __('Gcal', 'wc-vtbpay'),
            '70' => __('Day', 'wc-vtbpay'),
            '71' => __('Hour', 'wc-vtbpay'),
            '72' => __('Minute', 'wc-vtbpay'),
            '73' => __('Second', 'wc-vtbpay'),
            '80' => __('Kilobyte', 'wc-vtbpay'),
            '81' => __('Megabyte', 'wc-vtbpay'),
            '82' => __('Gigabyte', 'wc-vtbpay'),
            '83' => __('Terabyte', 'wc-vtbpay'),
            '255' => __('Applies when using other units of measurement', 'wc-vtbpay')
        ],
        'desc_tip' => true,
        'default' => '0',
        'priority' => 35
    ],
    'tax_type_fiscal' => [
        'title' => __('Tax rate', 'wc-vtbpay'),
        'type' => 'select',
        'description' => __('Default tax rate (for goods and services that do not have a specified tax rate).', 'wc-vtbpay'),
        'placeholder' => __('Enter tax rate.', 'wc-vtbpay'),
        'options' => [
            'none' => __('Without VAT', 'wc-vtbpay'),
            'vat0' => __('VAT at 0%', 'wc-vtbpay'),
            'vat10' => __('VAT at 10%', 'wc-vtbpay'),
            'vat110' => __('VAT at 10/110 calculated rate', 'wc-vtbpay'),
            'vat20' => __('VAT at 20%', 'wc-vtbpay'),
            'vat120' => __('VAT at 20/120 calculated rate', 'wc-vtbpay'),
            'vat5' => __('VAT at 5%', 'wc-vtbpay'),
            'vat7' => __('VAT at 7%', 'wc-vtbpay'),
            'vat105' => __('VAT at 5/105 calculated rate', 'wc-vtbpay'),
            'vat107' => __('VAT at 7/107 calculated rate', 'wc-vtbpay')
        ],
        'desc_tip' => true,
        'default' => 'none',
        'priority' => 36
    ],
    'payment_type_fiscal' => [
        'title' => __('Calculation method', 'wc-vtbpay'),
        'type' => 'select',
        'description' => __('Default payment method (for goods and services that do not have a payment method specified).', 'wc-vtbpay'),
        'placeholder' => __('Enter calculation method.', 'wc-vtbpay'),
        'options' => [
            'full_prepayment' => __('Prepayment 100%', 'wc-vtbpay'),
            'prepayment' => __('Prepayment', 'wc-vtbpay'),
            'advance' => __('Advance', 'wc-vtbpay'),
            'full_payment' => __('Full payment', 'wc-vtbpay'),
            'partial_payment' => __('Partial payment and credit', 'wc-vtbpay'),
            'credit' => __('Credit transfer', 'wc-vtbpay'),
            'credit_payment' => __('Credit payment', 'wc-vtbpay')
        ],
        'desc_tip' => true,
        'default' => 'full_prepayment',
        'priority' => 37
    ],
    'payment_subject_fiscal' => [
        'title' => __('Subject of calculation', 'wc-vtbpay'),
        'type' => 'select',
        'description' => __('The subject of calculation by default (for goods and services that do not specify the subject of calculation).', 'wc-vtbpay'),
        'placeholder' => __('Enter subject of calculation.', 'wc-vtbpay'),
        'options' => [
            '1' => __('Goods', 'wc-vtbpay'),
            '2' => __('Excise goods', 'wc-vtbpay'),
            '3' => __('Work', 'wc-vtbpay'),
            '4' => __('Service', 'wc-vtbpay'),
            '5' => __('Gambling bet', 'wc-vtbpay'),
            '6' => __('Gambling win', 'wc-vtbpay'),
            '7' => __('Lottery bet', 'wc-vtbpay'),
            '8' => __('Lottery win', 'wc-vtbpay'),
            '9' => __('Granting rights', 'wc-vtbpay'),
            '10' => __('Payment', 'wc-vtbpay'),
            '11' => __('Agency fee', 'wc-vtbpay'),
            '12' => __('Payout', 'wc-vtbpay'),
            '13' => __('Other calculation subject', 'wc-vtbpay'),
            '14' => __('Property right', 'wc-vtbpay'),
            '15' => __('Non-operating income', 'wc-vtbpay'),
            '16' => __('Insurance contributions', 'wc-vtbpay'),
            '17' => __('Trade fee', 'wc-vtbpay'),
            '18' => __('Resort fee', 'wc-vtbpay'),
            '19' => __('Deposit', 'wc-vtbpay'),
            '20' => __('Expense', 'wc-vtbpay'),
            '21' => __('Pension contributions for IP', 'wc-vtbpay'),
            '22' => __('Pension contributions', 'wc-vtbpay'),
            '23' => __('Health insurance contributions for IP', 'wc-vtbpay'),
            '24' => __('Health insurance contributions', 'wc-vtbpay'),
            '25' => __('Social insurance contributions', 'wc-vtbpay'),
            '26' => __('Casino payment', 'wc-vtbpay'),
            '27' => __('Cash issuance by bank payment agent', 'wc-vtbpay'),
            '30' => __('Excise goods subject to marking without code', 'wc-vtbpay'),
            '31' => __('Excise goods subject to marking with code', 'wc-vtbpay'),
            '32' => __('Goods subject to marking without code except excise goods', 'wc-vtbpay'),
            '33' => __('Goods subject to marking with code except excise goods', 'wc-vtbpay')
        ],
        'desc_tip' => true,
        'default' => '1',
        'priority' => 38
    ]
];

if (
    isset($_ENV['SHOW_RETURN_URL_FIELD']) &&
    $_ENV['SHOW_RETURN_URL_FIELD'] === '1'
) {
    $form_fields += [
        'return_url' => [
            'title' => __('Relative URL for refund after payment (without domain)', 'wc-vtbpay'),
            'type' => 'text',
            'description' => __('A post-payment refund page with a payment processor connected. Use #ID# where the order ID is required.', 'wc-vtbpay'),
            'placeholder' => __('Enter Return URL', 'wc-vtbpay'),
            'priority' => 12
        ]
    ];
}

// Сортируем по priority
uasort($form_fields, function ($a, $b) {
    return ($a['priority'] ?? 10) <=> ($b['priority'] ?? 10);
});

return $form_fields;
