document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('input[type="file"]').forEach(function (input) {
    const wrapper = document.createElement('div');
    wrapper.className = 'wp-core-ui custom-file-upload-wrapper';

    const button = document.createElement('button');
    button.type = 'button';
    button.className = 'button button-secondary';
    button.textContent = 'Добавить файл';

    const status = document.createElement('span');
    status.className = 'description';

    input.classList.add('custom-file-upload-hidden');

    // Получаем сохранённое значение
    const saved = input.getAttribute('value') || input.value;

    if (saved) {
      // Отображаем имя файла
      const name = saved.split(/[\\/]/).pop();
      status.textContent = 'Файл добавлен: ' + name;
      button.textContent = 'Заменить файл';

      // Если input был required, удаляем required, чтобы форма могла быть отправлена
      if (input.hasAttribute('required')) {
        input.removeAttribute('required');
      }
    }

    button.addEventListener('click', () => input.click());

    input.addEventListener('change', function () {
      if (input.files.length > 0) {
        status.textContent = 'Файл добавлен: ' + input.files[0].name;
        button.textContent = 'Заменить файл';
      } else {
        status.textContent = '';
        button.textContent = 'Добавить файл';
      }
    });

    input.parentNode.insertBefore(wrapper, input);
    wrapper.append(input, button, status);
  });
});
