<?php

use Joomla\CMS\Installer\InstallerAdapter;

class plgVmPaymentVtbpayInstallerScript
{
		/**
		 * Constructor
		 *
		 * @param   InstallerAdapter  $adapter  Объект, отвечающий за запуск этого скрипта
		 */
		public function __construct(InstallerAdapter $adapter)
		{
		}
		
		/**
		 * Called before any type of action
		 *
		 * @param   string  $route  Какое действие происходит (установить|удалить|discover_install|обновить)
		 * @param   InstallerAdapter  $adapter  Объект, отвечающий за запуск этого скрипта
		 *
		 * @return  boolean  True on success
		 */
		public function preflight($route, InstallerAdapter $adapter)
		{
				return true;
		}
		
		/**
		 * Called after any type of action
		 *
		 * @param   string  $route  Какое действие происходит (установить|удалить|discover_install|обновить)
		 * @param   InstallerAdapter  $adapter  Объект, отвечающий за запуск этого скрипта
		 *
		 * @return  boolean  True on success
		 */
		public function postflight($route, $adapter)
		{
				return true;
		}
		
		/**
		 * Called on installation
		 *
		 * @param   InstallerAdapter  $adapter  Объект, отвечающий за запуск этого скрипта
		 *
		 * @return  boolean  True on success
		 */
		public function install(InstallerAdapter $adapter)
		{
				$db = JFactory::getDbo();

				// Новый статус заказа
				$status = new stdClass();
				$status->order_status_code = 'V';
				$status->order_status_name = 'На удержании';

				// Проверяем, не существует ли уже запись с таким order_status_code
				$query = $db->getQuery(true)
					->select($db->quoteName('order_status_code'))
					->from($db->quoteName('#__virtuemart_orderstates'))
					->where($db->quoteName('order_status_code') . ' = ' . $db->quote($status->order_status_code));

				$db->setQuery($query);
				$existing_code = $db->loadResult();

				if (!$existing_code) {
						// Запись не существует, выполняем вставку
						$db->insertObject('#__virtuemart_orderstates', $status, 'order_status_id');
				}
				
				return true;
		}
		
		/**
		 * Called on update
		 *
		 * @param   InstallerAdapter  $adapter  Объект, отвечающий за запуск этого скрипта
		 *
		 * @return  boolean  True on success
		 */
		public function update(InstallerAdapter $adapter)
		{
				return true;
		}
		
		/**
		 * Called on uninstallation
		 *
		 * @param   InstallerAdapter  $adapter  Объект, отвечающий за запуск этого скрипта
		 */
		public function uninstall(InstallerAdapter $adapter)
		{
				$db = JFactory::getDbo();

				// Код статуса, который вы хотите удалить
				$status_to_delete_code = 'V';

				$query = $db->getQuery(true)
						->delete($db->quoteName('#__virtuemart_orderstates'))
						->where($db->quoteName('order_status_code') . ' = ' . $db->quote($status_to_delete_code));

				$db->setQuery($query);
				$db->execute();

				return true;
		}
}