<?php
defined('_JEXEC') or die('Restricted access');

JFormHelper::loadFieldClass('list');

class JFormFieldVmOrderStatus extends JFormFieldList
{
    protected $type = 'VmOrderStatus';

    public function getLabel() {
        // Initialize variables.
        $label = '';
        $replace = '';

        // Get the label text from the XML element, defaulting to the element name.
        $text = $this->element['label'] ? (string) $this->element['label'] : (string) $this->element['name'];

        // Build the class for the label.
        $class = !empty($this->description) ? 'hasTip' : '';
        $class = $this->required == true ? $class.' required' : $class;

        // Add the opening label tag and main attributes attributes.
        $label .= '<label id="'.$this->id.'-lbl" for="'.$this->id.'" class="'.$class.'"';

        // If a description is specified, use it to build a tooltip.
        if (!empty($this->description)) {
            $label .= ' title="'.htmlspecialchars(JText::_($this->description), ENT_COMPAT, 'UTF-8').'"';
        }

        // Add the label text and closing tag.
        $label .= '>'.$replace.JText::_($text);
        if ($this->required == true) $label .= '<span class="star" aria-hidden="true">&nbsp;*</span>';
        $label .= '</label>';

        return $label;
    }

    protected function getInput()
    {
        vmJsApi::addJScript('adminvtbpay', '/plugins/vmpayment/vtbpay/assets/js/admin_vtbpay.js');
        $db = JFactory::getDBO();
        $prefix = $db->getPrefix();
        $query = $db->getQuery(true);
        $query->select($db->quoteName(['order_status_code', 'order_status_name']));
        $query->from($db->quoteName($prefix . 'virtuemart_orderstates'));
        $db->setQuery($query);
        $results = $db->loadObjectList();
        $selected = $options = [];

        $defaultStatus = 'C';

        if ($results) {
            foreach($results as $result) {
                $option = JHtml::_('select.option', $result->order_status_code, JText::_($result->order_status_name));
                $options[] = $option;
                if(
                  $result->order_status_code === $this->value ||
                  $result->order_status_code === $defaultStatus && $this->value == ''
                )
                {
                  $selected[] = $option;
                }
            }
        }

        return JHtml::_('select.genericlist', $options, $this->name, '', 'value', 'text', $selected, $this->id);
    }
}
