<?php
defined('_JEXEC') or die('Restricted access');

JFormHelper::loadFieldClass('list');

class JFormFieldVmFiscalTax extends JFormFieldList
{
    protected $type = 'VmFiscalTax';

    public function getLabel() {
        // Initialize variables.
        $label = '';
        $replace = '';

        // Get the label text from the XML element, defaulting to the element name.
        $text = $this->element['label'] ? (string) $this->element['label'] : (string) $this->element['name'];

        // Build the class for the label.
        $class = !empty($this->description) ? 'hasTip' : '';
        $class = $this->required == true ? $class.' required' : $class;

        // Add the opening label tag and main attributes attributes.
        $label .= '<label id="'.$this->id.'-lbl" for="'.$this->id.'" class="'.$class.'"';

        // If a description is specified, use it to build a tooltip.
        if (!empty($this->description)) {
            $label .= ' title="'.htmlspecialchars(JText::_($this->description), ENT_COMPAT, 'UTF-8').'"';
        }

        // Add the label text and closing tag.
        $label .= '>'.$replace.JText::_($text);
        if ($this->required == true) $label .= '<span class="star" aria-hidden="true">&nbsp;*</span>';
        $label .= '</label>';

        return $label;
    }

    protected function getInput()
    {
        vmJsApi::addJScript('adminvtbpay', '/plugins/vmpayment/vtbpay/assets/js/admin_vtbpay.js');

        $results = [
            [
                'value' => 'none',
                'label' => 'Без НДС',
            ],
            [
                'value' => 'vat0',
                'label' => 'НДС по ставке 0%',
            ],
            [
                'value' => 'vat10',
                'label' => 'НДС чека по ставке 10%',
            ],
            [
                'value' => 'vat110',
                'label' => 'НДС чека по расчетной ставке 10/110',
            ],
            [
                'value' => 'vat20',
                'label' => 'НДС чека по ставке 20%',
            ],
            [
                'value' => 'vat120',
                'label' => 'НДС чека по расчетной ставке 20/120',
            ],
            [
                'value' => 'vat5',
                'label' => 'НДС чека по ставке 5%',
            ],
            [
                'value' => 'vat7',
                'label' => 'НДС чека по ставке 7%',
            ],
            [
                'value' => 'vat105',
                'label' => 'НДС чека по расчетной ставке 5/105',
            ],
            [
                'value' => 'vat107',
                'label' => 'НДС чека по расчетной ставке 7/107',
            ]
        ];
        $selected = $options = [];
        $default = 'none';

        foreach($results as $result) {
            $option = JHtml::_('select.option', $result['value'], JText::_($result['label']));
            $options[] = $option;
            if(
                $result['value'] === $this->value ||
                $result['value'] === $default && $this->value == ''
            )
            {
                $selected[] = $option;
            }
        }

        return JHtml::_('select.genericlist', $options, $this->name, '', 'value', 'text', $selected, $this->id);
    }
}
