<?php
defined('_JEXEC') or die('Restricted access');

JFormHelper::loadFieldClass('list');

class JFormFieldVmFiscalSubject extends JFormFieldList
{
    protected $type = 'VmFiscalSubject';

    public function getLabel() {
        // Initialize variables.
        $label = '';
        $replace = '';

        // Get the label text from the XML element, defaulting to the element name.
        $text = $this->element['label'] ? (string) $this->element['label'] : (string) $this->element['name'];

        // Build the class for the label.
        $class = !empty($this->description) ? 'hasTip' : '';
        $class = $this->required == true ? $class.' required' : $class;

        // Add the opening label tag and main attributes attributes.
        $label .= '<label id="'.$this->id.'-lbl" for="'.$this->id.'" class="'.$class.'"';

        // If a description is specified, use it to build a tooltip.
        if (!empty($this->description)) {
            $label .= ' title="'.htmlspecialchars(JText::_($this->description), ENT_COMPAT, 'UTF-8').'"';
        }

        // Add the label text and closing tag.
        $label .= '>'.$replace.JText::_($text);
        if ($this->required == true) $label .= '<span class="star" aria-hidden="true">&nbsp;*</span>';
        $label .= '</label>';

        return $label;
    }

    protected function getInput()
    {
        vmJsApi::addJScript('adminvtbpay', '/plugins/vmpayment/vtbpay/assets/js/admin_vtbpay.js');

        $results = [
            [
                'value' => 1,
                'label' => 'Товар',
            ],
            [
                'value' => 2,
                'label' => 'Подакцизный товар',
            ],
            [
                'value' => 3,
                'label' => 'Работа',
            ],
            [
                'value' => 4,
                'label' => 'Услуга',
            ],
            [
                'value' => 5,
                'label' => 'Ставка азартной игры',
            ],
            [
                'value' => 6,
                'label' => 'Выигрыш азартной игры',
            ],
            [
                'value' => 7,
                'label' => 'Ставка лотереи',
            ],
            [
                'value' => 8,
                'label' => 'Выигрыш лотереи',
            ],
            [
                'value' => 9,
                'label' => 'Предоставление прав',
            ],
            [
                'value' => 10,
                'label' => 'Платеж',
            ],
            [
                'value' => 11,
                'label' => 'Агентское вознаграждение',
            ],
            [
                'value' => 12,
                'label' => 'Выплата',
            ],
            [
                'value' => 13,
                'label' => 'Иной предмет расчёта',
            ],
            [
                'value' => 14,
                'label' => 'Имущественное право',
            ],
            [
                'value' => 15,
                'label' => 'Внереализационный доход',
            ],
            [
                'value' => 16,
                'label' => 'Страховые взносы',
            ],
            [
                'value' => 17,
                'label' => 'Торговый сбор',
            ],
            [
                'value' => 18,
                'label' => 'Курортный сбор',
            ],
            [
                'value' => 19,
                'label' => 'Залог',
            ],
            [
                'value' => 20,
                'label' => 'Расход',
            ],
            [
                'value' => 21,
                'label' => 'Взносы на ОПС ИП',
            ],
            [
                'value' => 22,
                'label' => 'Взносы ОПС',
            ],
            [
                'value' => 23,
                'label' => 'Взносы на ОМС ИП',
            ],
            [
                'value' => 24,
                'label' => 'Взносы на ОМС',
            ],
            [
                'value' => 25,
                'label' => 'Взносы на ОСС',
            ],
            [
                'value' => 26,
                'label' => 'Платеж казино',
            ],
            [
                'value' => 27,
                'label' => 'Выдача денежных средств банковским платежным агентом',
            ],
            [
                'value' => 30,
                'label' => 'Подакцизный товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки',
            ],
            [
                'value' => 31,
                'label' => 'Подакцизный товар, подлежащий маркировке средством идентификации, имеющий код маркировки',
            ],
            [
                'value' => 32,
                'label' => 'Товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки, за исключением подакцизного товара',
            ],
            [
                'value' => 33,
                'label' => 'Товар, подлежащий маркировке средством идентификации, имеющий код маркировки, за исключением подакцизного товара',
            ]
        ];
        $selected = $options = [];
        $default = '1';

        foreach($results as $result) {
            $option = JHtml::_('select.option', $result['value'], JText::_($result['label']));
            $options[] = $option;
            if(
                $result['value'] === $this->value ||
                $result['value'] === $default && $this->value == ''
            )
            {
                $selected[] = $option;
            }
        }

        return JHtml::_('select.genericlist', $options, $this->name, '', 'value', 'text', $selected, $this->id);
    }
}
