<?php
defined('_JEXEC') or die('Restricted access');

JFormHelper::loadFieldClass('list');

class JFormFieldVmFiscalPayment extends JFormFieldList
{
    protected $type = 'VmFiscalPayment';

    public function getLabel() {
        // Initialize variables.
        $label = '';
        $replace = '';

        // Get the label text from the XML element, defaulting to the element name.
        $text = $this->element['label'] ? (string) $this->element['label'] : (string) $this->element['name'];

        // Build the class for the label.
        $class = !empty($this->description) ? 'hasTip' : '';
        $class = $this->required == true ? $class.' required' : $class;

        // Add the opening label tag and main attributes attributes.
        $label .= '<label id="'.$this->id.'-lbl" for="'.$this->id.'" class="'.$class.'"';

        // If a description is specified, use it to build a tooltip.
        if (!empty($this->description)) {
            $label .= ' title="'.htmlspecialchars(JText::_($this->description), ENT_COMPAT, 'UTF-8').'"';
        }

        // Add the label text and closing tag.
        $label .= '>'.$replace.JText::_($text);
        if ($this->required == true) $label .= '<span class="star" aria-hidden="true">&nbsp;*</span>';
        $label .= '</label>';

        return $label;
    }

    protected function getInput()
    {
        vmJsApi::addJScript('adminvtbpay', '/plugins/vmpayment/vtbpay/assets/js/admin_vtbpay.js');

        $results = [
            [
                'value' => 'full_prepayment',
                'label' => 'Предоплата 100%',
            ],
            [
                'value' => 'prepayment',
                'label' => 'Предоплата',
            ],
            [
                'value' => 'advance',
                'label' => 'Аванс',
            ],
            [
                'value' => 'full_payment',
                'label' => 'Полный расчет',
            ],
            [
                'value' => 'partial_payment',
                'label' => 'Частичный расчет и кредит',
            ],
            [
                'value' => 'credit',
                'label' => 'Передача в кредит',
            ],
            [
                'value' => 'credit_payment',
                'label' => 'Оплата кредита',
            ]
        ];
        $selected = $options = [];
        $default = 'full_prepayment';

        foreach($results as $result) {
            $option = JHtml::_('select.option', $result['value'], JText::_($result['label']));
            $options[] = $option;
            if(
                $result['value'] === $this->value ||
                $result['value'] === $default && $this->value == ''
            )
            {
                $selected[] = $option;
            }
        }

        return JHtml::_('select.genericlist', $options, $this->name, '', 'value', 'text', $selected, $this->id);
    }
}
