<?php
defined('_JEXEC') or die('Restricted access');

JFormHelper::loadFieldClass('list');

class JFormFieldVmFiscalMeasure extends JFormFieldList
{
    protected $type = 'VmFiscalMeasure';

    public function getLabel() {
        // Initialize variables.
        $label = '';
        $replace = '';

        // Get the label text from the XML element, defaulting to the element name.
        $text = $this->element['label'] ? (string) $this->element['label'] : (string) $this->element['name'];

        // Build the class for the label.
        $class = !empty($this->description) ? 'hasTip' : '';
        $class = $this->required == true ? $class.' required' : $class;

        // Add the opening label tag and main attributes attributes.
        $label .= '<label id="'.$this->id.'-lbl" for="'.$this->id.'" class="'.$class.'"';

        // If a description is specified, use it to build a tooltip.
        if (!empty($this->description)) {
            $label .= ' title="'.htmlspecialchars(JText::_($this->description), ENT_COMPAT, 'UTF-8').'"';
        }

        // Add the label text and closing tag.
        $label .= '>'.$replace.JText::_($text);
        if ($this->required == true) $label .= '<span class="star" aria-hidden="true">&nbsp;*</span>';
        $label .= '</label>';

        return $label;
    }

    protected function getInput()
    {
        vmJsApi::addJScript('adminvtbpay', '/plugins/vmpayment/vtbpay/assets/js/admin_vtbpay.js');

        $results = [
            [
                'value' => 0,
                'label' => 'Применяется для предметов расчета, которые могут быть реализованы поштучно или единицами',
            ],
            [
                'value' => 10,
                'label' => 'Грамм',
            ],
            [
                'value' => 11,
                'label' => 'Килограмм',
            ],
            [
                'value' => 12,
                'label' => 'Тонна',
            ],
            [
                'value' => 20,
                'label' => 'Сантиметр',
            ],
            [
                'value' => 21,
                'label' => 'Дециметр',
            ],
            [
                'value' => 22,
                'label' => 'Метр',
            ],
            [
                'value' => 30,
                'label' => 'Квадратный сантиметр',
            ],
            [
                'value' => 31,
                'label' => 'Квадратный дециметр',
            ],
            [
                'value' => 32,
                'label' => 'Квадратный метр',
            ],
            [
                'value' => 40,
                'label' => 'Миллилитр',
            ],
            [
                'value' => 41,
                'label' => 'Литр',
            ],
            [
                'value' => 42,
                'label' => 'Кубический метр',
            ],
            [
                'value' => 50,
                'label' => 'Киловатт час',
            ],
            [
                'value' => 51,
                'label' => 'Гигакалория',
            ],
            [
                'value' => 70,
                'label' => 'Сутки (день)',
            ],
            [
                'value' => 71,
                'label' => 'Час',
            ],
            [
                'value' => 72,
                'label' => 'Минута',
            ],
            [
                'value' => 73,
                'label' => 'Секунда',
            ],
            [
                'value' => 80,
                'label' => 'Килобайт',
            ],
            [
                'value' => 81,
                'label' => 'Мегабайт',
            ],
            [
                'value' => 82,
                'label' => 'Гигабайт',
            ],
            [
                'value' => 83,
                'label' => 'Терабайт',
            ],
            [
                'value' => 255,
                'label' => 'Применяется при использовании иных единиц измерения',
            ]
        ];
        $selected = $options = [];
        $default = '0';

        foreach($results as $result) {
            $option = JHtml::_('select.option', $result['value'], JText::_($result['label']));
            $options[] = $option;
            if(
                $result['value'] === $this->value ||
                $result['value'] === $default && $this->value == ''
            )
            {
                $selected[] = $option;
            }
        }

        return JHtml::_('select.genericlist', $options, $this->name, '', 'value', 'text', $selected, $this->id);
    }
}
