<?php
return [
    'client_id' => [
        'value' => '',
        'title' => 'Client ID *',
        'description' => _wp('Для вызова API требуется идентификатор клиента продавца.'),
        'control_type' => 'input',
        'required' => true
    ],
    'client_secret' => [
        'value' => '',
        'title' => 'Client Secret *',
        'description' => _wp('Для вызова API требуется секретный ключ продавца.'),
        'control_type' => 'input',
        'required' => true
    ],
    'merchant_authorization' => [
        'value' => '',
        'title' => 'Merchant-Authorization',
        'description' => _wp('Заголовок запроса, используемый ресурсом мерчанта для дополнительной аутентификации при доступе к платежному шлюзу.'),
        'control_type' => 'input',
    ],
    'test_mode' => [
        'value' => '0',
        'title' => _wp('Включить тестовый режим'),
        'description' => _wp('В этом режиме оплата за товар не взимается.'),
        'control_type' => 'checkbox',
    ],
    'logging' => [
        'value' => '0',
        'title' => _wp('Включить логирование'),
        'description' => _wp('Логирование используется для отладки производительности плагина путем сохранения данных запросов к API.'),
        'control_type' => 'checkbox',
    ],
    'two_stage' => [
        'value' => '0',
        'title' => _wp('Включить двустадийный платеж'),
        'description' => _wp('Платеж в 2 этапа: удержание средств после оплаты, затем подтверждение списания или отмена удержания мерчантом через личный кабинет.'),
        'control_type' => 'checkbox',
    ],
    'section_fiscal' => [
        'description' => '<h3>' . _wp('Настройки фискализации') . '</h3><br>',
        'control_type' => waHtmlControl::CUSTOM
    ],
    'enable_fiscal' => [
        'value' => '0',
        'title' => _wp('Включить фискализацию'),
        'description' => _wp('Включение и отключение фискализации (поставьте галочку чтобы включить фискализацию).'),
        'control_type' => 'checkbox',
    ],
    'email_fiscal' => [
        'value' => '',
        'title' => 'Email',
        'description' => _wp('Электронная почта для отправки фискального чека, если не указана почта пользователя.'),
        'control_type' => 'input'
    ],
    'payment_type_delivery_fiscal' => [
        'value' => 'full_prepayment',
        'title' => _wp('Способ расчета для доставки'),
        'description' => _wp('Способ расчета для услуги доставки.'),
        'control_type' => waHtmlControl::SELECT,
        'options' => [
            ['value' => 'full_prepayment', 'title' => _wp('Предоплата 100%'), 'description' => _wp('Полная предварительная оплата до момента передачи предмета расчета')],
            ['value' => 'prepayment', 'title' => _wp('Предоплата'), 'description' => _wp('Частичная предварительная оплата до момента передачи предмета расчета')],
            ['value' => 'advance', 'title' => _wp('Аванс')],
            ['value' => 'full_payment', 'title' => _wp('Полный расчет'), 'description' => _wp('Полная оплата, в том числе с учетом аванса (предварительной оплаты) в момент передачи предмета расчета')],
            ['value' => 'partial_payment', 'title' => _wp('Частичный расчет и кредит'), 'description' => _wp('Частичная оплата предмета расчета в момент его передачи с последующей оплатой в кредит')],
            ['value' => 'credit', 'title' => _wp('Передача в кредит'), 'description' => _wp('Передача предмета расчета без его оплаты в момент его передачи с последующей оплатой в кредит')],
            ['value' => 'credit_payment', 'title' => _wp('Оплата кредита'), 'description' => _wp('Оплата предмета расчета после его передачи с оплатой в кредит (оплата кредита)')]
        ]
    ],
    'measure_fiscal' => [
        'value' => '0',
        'title' => _wp('Единицы измерения'),
        'description' => _wp('Единицы измерения количества предмета расчета.'),
        'control_type' => waHtmlControl::SELECT,
        'options' => [
            ['value' => '0', 'title' => _wp('Применяется для предметов расчета, которые могут быть реализованы поштучно или единицами')],
            ['value' => '10', 'title' => _wp('Грамм')],
            ['value' => '11', 'title' => _wp('Килограмм')],
            ['value' => '12', 'title' => _wp('Тонна')],
            ['value' => '20', 'title' => _wp('Сантиметр')],
            ['value' => '21', 'title' => _wp('Дециметр')],
            ['value' => '22', 'title' => _wp('Метр')],
            ['value' => '30', 'title' => _wp('Квадратный сантиметр')],
            ['value' => '31', 'title' => _wp('Квадратный дециметр')],
            ['value' => '32', 'title' => _wp('Квадратный метр')],
            ['value' => '40', 'title' => _wp('Миллилитр')],
            ['value' => '41', 'title' => _wp('Литр')],
            ['value' => '42', 'title' => _wp('Кубический метр')],
            ['value' => '50', 'title' => _wp('Киловатт час')],
            ['value' => '51', 'title' => _wp('Гигакалория')],
            ['value' => '70', 'title' => _wp('Сутки (день)')],
            ['value' => '71', 'title' => _wp('Час')],
            ['value' => '72', 'title' => _wp('Минута')],
            ['value' => '73', 'title' => _wp('Секунда')],
            ['value' => '80', 'title' => _wp('Килобайт')],
            ['value' => '81', 'title' => _wp('Мегабайт')],
            ['value' => '82', 'title' => _wp('Гигабайт')],
            ['value' => '83', 'title' => _wp('Терабайт')],
            ['value' => '255', 'title' => _wp('Применяется при использовании иных единиц измерения')]
        ]
    ],
    'tax_type_fiscal' => [
        'value' => 'none',
        'title' => _wp('Ставка налогообложения'),
        'description' => _wp('Устанавливает номер налога в ККТ.'),
        'control_type' => waHtmlControl::SELECT,
        'options' => [
            ['value' => 'none', 'title' => _wp('Без НДС')],
            ['value' => 'vat0', 'title' => _wp('НДС по ставке 0%')],
            ['value' => 'vat10', 'title' => _wp('НДС чека по ставке 10%')],
            ['value' => 'vat110', 'title' => _wp('НДС чека по расчетной ставке 10/110')],
            ['value' => 'vat20', 'title' => _wp('НДС чека по ставке 20%')],
            ['value' => 'vat120', 'title' => _wp('НДС чека по расчетной ставке 20/120')],
            ['value' => 'vat5', 'title' => _wp('НДС чека по ставке 5%')],
            ['value' => 'vat7', 'title' => _wp('НДС чека по ставке 7%')],
            ['value' => 'vat105', 'title' => _wp('НДС чека по расчетной ставке 5/105')],
            ['value' => 'vat107', 'title' => _wp('НДС чека по расчетной ставке 7/107')]
        ]
    ],
    'payment_type_fiscal' => [
        'value' => 'full_prepayment',
        'title' => _wp('Способ расчета'),
        'description' => _wp('Признак способа расчёта.'),
        'control_type' => waHtmlControl::SELECT,
        'options' => [
            ['value' => 'full_prepayment', 'title' => _wp('Предоплата 100%'), 'description' => _wp('Полная предварительная оплата до момента передачи предмета расчета')],
            ['value' => 'prepayment', 'title' => _wp('Предоплата'), 'description' => _wp('Частичная предварительная оплата до момента передачи предмета расчета')],
            ['value' => 'advance', 'title' => _wp('Аванс')],
            ['value' => 'full_payment', 'title' => _wp('Полный расчет'), 'description' => _wp('Полная оплата, в том числе с учетом аванса (предварительной оплаты) в момент передачи предмета расчета')],
            ['value' => 'partial_payment', 'title' => _wp('Частичный расчет и кредит'), 'description' => _wp('Частичная оплата предмета расчета в момент его передачи с последующей оплатой в кредит')],
            ['value' => 'credit', 'title' => _wp('Передача в кредит'), 'description' => _wp('Передача предмета расчета без его оплаты в момент его передачи с последующей оплатой в кредит')],
            ['value' => 'credit_payment', 'title' => _wp('Оплата кредита'), 'description' => _wp('Оплата предмета расчета после его передачи с оплатой в кредит (оплата кредита)')]
        ]
    ],
    'payment_subject_fiscal' => [
        'value' => '1',
        'title' => _wp('Предмет расчета'),
        'description' => _wp('Признак предмета расчёта.'),
        'control_type' => waHtmlControl::SELECT,
        'options' => [
            ['value' => '1', 'title' => _wp('Товар'), 'description' => _wp('О реализуемом товаре, за исключением подакцизного товара и товара, подлежащего маркировке средствами идентификации (наименование и иные сведения, описывающие товар) работе (наименование и иные сведения, описывающие работу)')],
            ['value' => '2', 'title' => _wp('Подакцизный товар'), 'description' => _wp('О реализуемом подакцизном товаре, за исключением товара, подлежащего маркировке средствами идентификации (наименование и иные сведения, описывающие товар)')],
            ['value' => '3', 'title' => _wp('Работа'), 'description' => _wp('О выполняемой работе (наименование и иные сведения, описывающие работу)')],
            ['value' => '4', 'title' => _wp('Услуга'), 'description' => _wp('Об оказываемой услуге (наименование и иные сведения, описывающие услугу)')],
            ['value' => '5', 'title' => _wp('Ставка азартной игры'), 'description' => _wp('О приеме ставок при осуществлении деятельности по проведению азартных игр')],
            ['value' => '6', 'title' => _wp('Выигрыш азартной игры'), 'description' => _wp('О выплате денежных средств в виде выигрыша при осуществлении деятельности по проведению азартных игр')],
            ['value' => '7', 'title' => _wp('Ставка лотереи'), 'description' => _wp('О приеме денежных средств при реализации лотерейных билетов, электронных лотерейных билетов, приеме лотерейных ставок при осуществлении деятельности по проведению лотерей')],
            ['value' => '8', 'title' => _wp('Выигрыш лотере'), 'description' => _wp('О выплате денежных средств в виде выигрыша при осуществлении деятельности по проведению лотерей')],
            ['value' => '9', 'title' => _wp('Предоставление рид'), 'description' => _wp('О предоставлении прав на использование результатов интеллектуальной деятельности или средств индивидуализации')],
            ['value' => '10', 'title' => _wp('Платеж'), 'description' => _wp('Об авансе, задатке, предоплате, кредите')],
            ['value' => '11', 'title' => _wp('Агентское вознаграждение'), 'description' => _wp('О вознаграждении пользователя, являющегося платежным агентом (субагентом), банковским платежным агентом (субагентом), комиссионером, поверенным или иным агентом')],
            ['value' => '12', 'title' => _wp('Выплата'), 'description' => _wp('О взносе в счет оплаты, пени, штрафе, вознаграждении, бонусе и ином аналогичном предмете расчета')],
            ['value' => '13', 'title' => _wp('Иной предмет расчёта'), 'description' => _wp('О предмете расчета, не относящемуся к предметам расчета, которым может быть присвоено значение от «1» до «11» и от «14» до «26»')],
            ['value' => '14', 'title' => _wp('Имущественное право'), 'description' => _wp('О передаче имущественных прав')],
            ['value' => '15', 'title' => _wp('Внереализационный доход'), 'description' => _wp('О внереализационном доходе')],
            ['value' => '16', 'title' => _wp('Страховые взносы'), 'description' => _wp('О суммах расходов, платежей и взносов, указанных в подпунктах 2 и 3 пункта Налогового кодекса Российской Федерации, уменьшающих сумму налога')],
            ['value' => '17', 'title' => _wp('Торговый сбор'), 'description' => _wp('О суммах уплаченного торгового сбора')],
            ['value' => '18', 'title' => _wp('Курортный сбор'), 'description' => _wp('О курортном сборе')],
            ['value' => '19', 'title' => _wp('Залог'), 'description' => _wp('О залоге')],
            ['value' => '20', 'title' => _wp('Расход'), 'description' => _wp('О суммах произведенных расходов в соответствии со статьей 346.16 Налогового кодекса Российской Федерации, уменьшающих доход')],
            ['value' => '21', 'title' => _wp('Взносы на ОПС ИП'), 'description' => _wp('О страховых взносах на обязательное пенсионное страхование, уплачиваемых ИП, не производящими выплаты и иные вознаграждения физическим лицам')],
            ['value' => '22', 'title' => _wp('Взносы ОПС'), 'description' => _wp('О страховых взносах на обязательное пенсионное страхование, уплачиваемых организациями и ИП, производящими выплаты и иные вознаграждения физическим лицам')],
            ['value' => '23', 'title' => _wp('Взносы на ОМС ИП'), 'description' => _wp('О страховых взносах на обязательное медицинское страхование, уплачиваемых ИП, не производящими выплаты и иные вознаграждения физическим лицам')],
            ['value' => '24', 'title' => _wp('Взносы на ОМС'), 'description' => _wp('О страховых взносах на обязательное медицинское страхование, уплачиваемые организациями и ИП, производящими выплаты и иные вознаграждения физическим лицам')],
            ['value' => '25', 'title' => _wp('Взносы на ОСС'), 'description' => _wp('О страховых взносах на обязательное социальное страхование на случай временной нетрудоспособности и в связи с материнством, на обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний')],
            ['value' => '26', 'title' => _wp('Платеж казино'), 'description' => _wp('О приеме и выплате денежных средств при осуществлении казино и залами игровых автоматов расчетов с использованием обменных знаков игорного заведения')],
            ['value' => '27', 'title' => _wp('Выдача денежных средств банковским платежным агентом')],
            ['value' => '30', 'title' => _wp('Подакцизный товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки')],
            ['value' => '31', 'title' => _wp('Подакцизный товар, подлежащий маркировке средством идентификации, имеющий код маркировки')],
            ['value' => '32', 'title' => _wp('Товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки, за исключением подакцизного товара')],
            ['value' => '33', 'title' => _wp('Товар, подлежащий маркировке средством идентификации, имеющий код маркировки, за исключением подакцизного товара')]
        ]
    ]
];
