<?php
/**
 * @package       Vtb Pay Module for ReadyScript
 * @author        ВТБ (ПАО)
 */
namespace VtbPay\Model\Log;

use RS\Log\AbstractLog;

/**
 * Класс логирования
 */
class VtbLog extends AbstractLog
{
    const LEVEL_DEBUG = 'debug';
    const LEVEL_ERROR = 'error';


    /**
     * Возвращает идентификатор класса логирования
     *
     * @return string
     */
    public function getIdentifier(): string
    {
        return 'vtbpay';
    }


    /**
     * Возвращает название класса логирования
     *
     * @return string
     */
    public function getTitle(): string
    {
        return t('Платежный шлюз ВТБ');
    }


    /**
     * Возвращает список допустимых уровней лог-записей
     *
     * @return string[]
     */
    protected function selfLogLevelList(): array
    {
        return [
            self::LEVEL_DEBUG => t('Сообщения отладки'),
            self::LEVEL_ERROR => t('Ошибки'),
        ];
    }
}
