<?php
/**
 * @package       VtbPay Module for ReadyScript
 * @author        ВТБ (ПАО)
 */

namespace VtbPay\Controller\Front;

use \Shop\Model\Orm\Transaction,
    \Shop\Model\PaymentType\ResultException,
    \RS\Controller\Front,
    \VtbPay\Model\PaymentType\VtbPay,
    \VtbPay\Src\Classes\Exception\VtbPayException;

class Webhook extends Front
{
    private VtbPay $payment;
    private Transaction $transaction;


    /**
     * Подготовка данных и запуск проверки и смены статуса транзакции
     */
    public function actionIndex()
    {
        $php_input = json_decode(file_get_contents('php://input'), true) ?: null;

        $this->transaction = new Transaction($php_input['object']['orderId'] ?? '');
        if (empty($this->transaction->id)) {
            throw (new ResultException(t('Транзакция не найдена.')))
                ->setUpdateTransaction(false); // Не устанавливаем статус FAIL транзакции
        }

        $this->wrapOutput(false); // Отключаем html обёртку

        $this->checkProcess(); // Получаем результат

        $this->result->checkAjaxOutput(true); // Указываем что возвращаем json

        $this->result->addSection(
            'success',
            $this->result->isSuccess()
        ); // Указываем success в true или в false

        return $this->result->getOutput(true); // Возвращаем json
    }


    /**
     * Проверяет статус оплаты в ВТБ и меняет статус транзакции
     */
    private function checkProcess()
    {
        try {
            $this->setPayment();
            $this->payment->setVtbpayLogger()->setOption('additionalCommonText', 'webhook-' . rand(1111, 9999));
            $this->payment->setVtbApi();

            // Logging request data
            $this->payment->logger->debug(
                __CLASS__ . ' > ' . __FUNCTION__ . ' > webhook - INPUT: ', [
                'php_input' => json_decode(file_get_contents('php://input'), true)
            ]);

            $payment_status_data = $this->payment->getPaymentStatusData();
            $this->payment->changePaymentStatus($payment_status_data);

            $this->result->setSuccess(in_array(
              $payment_status_data['object']['status']['value'] ?? '',
              ['PAID', 'PENDING']
            ));

        } catch (\Exception | VtbPayException $e) {
            // Handle exception and log error
            $context = [
                'file_exception' => $e->getFile(),
                'line_exception' => $e->getLine(),
            ];
            if (method_exists($e, 'getContext')) $context = array_merge($e->getContext(), $context);

            $this->payment->logger->error(sprintf(
                __CLASS__ . ' > ' . __FUNCTION__ . ' > VtbPay exception : %s; Transaction id: %s;',
                $e->getMessage(),
                $this->transaction->id ?: ''
            ), $context);

            // Set payment response for failure.
            $order_status = $context['order_status'] ?? Transaction::STATUS_FAIL;
            $reason_text = $context['reason_text'] ?? $e->getMessage();

            $this->payment->changeTransactionAndOrderStatus(
                $order_status,
                $reason_text
            );

            $this->result->addSection(
                'error',
                $e->getMessage()
            );
        }
    }


    /**
     * Инициализация объекта оплаты
     *
     * @return self
     */
    private function setPayment(): self
    {
        $this->payment = $this->transaction->getPayment()->getTypeObject();
        return $this;
    }
}
