<?php
return [
    '__info__' => new \RS\Orm\Type\MixedType([
        'description' => '<b>' . t('Настройки платёжной системы ВТБ') . '</b>',
        'visible' => true,
        'template' => '%vtbpay%/form/payment/vtbpay/info.tpl'
    ]),
    'client_id' => new \RS\Orm\Type\Varchar([
        'description' => t('Client ID'),
        'hint' => t('Для вызова API требуется идентификатор клиента продавца.')
    ]),
    'client_secret' => new \RS\Orm\Type\Varchar([
        'description' => t('Client Secret'),
        'hint' => t('Для вызова API требуется секретный ключ продавца.')
    ]),
    'client_merchant' => new \RS\Orm\Type\Varchar([
        'description' => t('Merchant-Authorization'),
        'hint' => t('Заголовок запроса, используемый ресурсом мерчанта для дополнительной аутентификации при доступе к платежному шлюзу.')
    ]),
    'test_mode' => new \RS\Orm\Type\Integer([
        'description' => t('Тестовый режим'),
        'hint' => t('В этом режиме оплата за товар не взимается.'),
        'maxLength' => 1,
        'default' => 0,
        'CheckboxView' => [1, 0]
    ]),
    'logging' => new \RS\Orm\Type\Integer([
        'description' => t('Логирование'),
        'hint' => t('Логирование используется для отладки производительности плагина путем сохранения данных запросов к API.'),
        'maxLength' => 1,
        'default' => 0,
        'CheckboxView' => [1, 0]
    ]),
    'two_stage' => new \RS\Orm\Type\Integer([
        'description' => t('Двухстадийный платеж'),
        'hint' => t('Платеж в 2 этапа: удержание средств после оплаты, затем подтверждение списания или отмена удержания мерчантом через личный кабинет.'),
        'maxLength' => 1,
        'default' => 0,
        'CheckboxView' => [1, 0]
    ]),
    '__section_fiscal__' => new \RS\Orm\Type\MixedType([
        'description' => '<b>' . t('Настройки фискализации') . '</b>',
        'visible' => true,
        'template' => '%vtbpay%/form/payment/vtbpay/separator.tpl'
    ]),
    'enable_fiscal' => new \RS\Orm\Type\Integer([
        'description' => t('Включить фискализацию'),
        'hint' => t('Включение и отключение фискализации (поставьте галочку чтобы включить фискализацию).'),
        'maxLength' => 1,
        'default' => 0,
        'CheckboxView' => [1, 0]
    ]),
    'email_fiscal' => new \RS\Orm\Type\Varchar([
        'description' => t('Электронная почта'),
        'hint' => t('Электронная почта для отправки фискального чека, если не указана почта пользователя.')
    ]),
    'payment_type_delivery_fiscal' => new \RS\Orm\Type\Varchar([
        'description' => t('Способ расчета для доставки'),
        'hint' => t('Способ расчета для услуги доставки.'),
        'listFromArray' => [
            [
                'full_prepayment' => 'Предоплата 100%',
                'prepayment' => 'Предоплата',
                'advance' => 'Аванс',
                'full_payment' => 'Полный расчет',
                'partial_payment' => 'Частичный расчет и кредит',
                'credit' => 'Передача в кредит',
                'credit_payment' => 'Оплата кредита'
            ]
        ],
        'default' => 'full_prepayment'
    ]),
    '__section_subtitle_fiscal__' => new \RS\Orm\Type\MixedType([
        'description' => '<b>' . t('Настройки для товаров и услуг по умолчанию') . '</b>',
        'visible' => true,
        'template' => '%vtbpay%/form/payment/vtbpay/separator.tpl'
    ]),
    'measure_fiscal' => new \RS\Orm\Type\Varchar([
        'description' => t('Единицы измерения'),
        'hint' => t('Единицы измерения по умолчанию (для товаров и услуг, у которых не указана единица измерения).'),
        'listFromArray' => [
            [
                '0' => 'Применяется для предметов расчета, которые могут быть реализованы поштучно или единицами',
                '10' => 'Грамм',
                '11' => 'Килограмм',
                '12' => 'Тонна',
                '20' => 'Сантиметр',
                '21' => 'Дециметр',
                '22' => 'Метр',
                '30' => 'Квадратный сантиметр',
                '31' => 'Квадратный дециметр',
                '32' => 'Квадратный метр',
                '40' => 'Миллилитр',
                '41' => 'Литр',
                '42' => 'Кубический метр',
                '50' => 'Киловатт час',
                '51' => 'Гигакалория',
                '70' => 'Сутки (день)',
                '71' => 'Час',
                '72' => 'Минута',
                '73' => 'Секунда',
                '80' => 'Килобайт',
                '81' => 'Мегабайт',
                '82' => 'Гигабайт',
                '83' => 'Терабайт',
                '255' => 'Применяется при использовании иных единиц измерения'
            ]
        ],
        'default' => '0'
    ]),
    'tax_type_fiscal' => new \RS\Orm\Type\Varchar([
        'description' => t('Налоговая ставка'),
        'hint' => t('Ставка налогообложения по умолчанию (для товаров и услуг, у которых не указана ставка налогообложения).'),
        'listFromArray' => [
            [
                'none' => 'Без НДС',
                'vat0' => 'НДС по ставке 0%',
                'vat10' => 'НДС чека по ставке 10%',
                'vat110' => 'НДС чека по расчетной ставке 10/110',
                'vat20' => 'НДС чека по ставке 20%',
                'vat120' => 'НДС чека по расчетной ставке 20/120',
                'vat5' => 'НДС чека по ставке 5%',
                'vat7' => 'НДС чека по ставке 7%',
                'vat105' => 'НДС чека по расчетной ставке 5/105',
                'vat107' => 'НДС чека по расчетной ставке 7/107'
            ]
        ],
        'default' => 'none'
    ]),
    'payment_type_fiscal' => new \RS\Orm\Type\Varchar([
        'description' => t('Способ расчета'),
        'hint' => t('Способ расчета по умолчанию (для товаров и услуг, у которых не указан способ расчета).'),
        'listFromArray' => [
            [
                'full_prepayment' => 'Предоплата 100%',
                'prepayment' => 'Предоплата',
                'advance' => 'Аванс',
                'full_payment' => 'Полный расчет',
                'partial_payment' => 'Частичный расчет и кредит',
                'credit' => 'Передача в кредит',
                'credit_payment' => 'Оплата кредита'
            ]
        ],
        'default' => 'full_prepayment'
    ]),
    'payment_subject_fiscal' => new \RS\Orm\Type\Varchar([
        'description' => t('Предмет расчета'),
        'hint' => t('Предмет расчета по умолчанию (для товаров и услуг, у которых не указан предмет расчета).'),
        'listFromArray' => [
            [
                '1' => 'Товар',
                '2' => 'Подакцизный товар',
                '3' => 'Работа',
                '4' => 'Услуга',
                '5' => 'Ставка азартной игры',
                '6' => 'Выигрыш азартной игры',
                '7' => 'Ставка лотереи',
                '8' => 'Выигрыш лотереи',
                '9' => 'Предоставление прав',
                '10' => 'Платеж',
                '11' => 'Агентское вознаграждение',
                '12' => 'Выплата',
                '13' => 'Иной предмет расчёта',
                '14' => 'Имущественное право',
                '15' => 'Внереализационный доход',
                '16' => 'Страховые взносы',
                '17' => 'Торговый сбор',
                '18' => 'Курортный сбор',
                '19' => 'Залог',
                '20' => 'Расход',
                '21' => 'Взносы на ОПС ИП',
                '22' => 'Взносы ОПС',
                '23' => 'Взносы на ОМС ИП',
                '24' => 'Взносы на ОМС',
                '25' => 'Взносы на ОСС',
                '26' => 'Платеж казино',
                '27' => 'Выдача денежных средств банковским платежным агентом',
                '30' => 'Подакцизный товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки',
                '31' => 'Подакцизный товар, подлежащий маркировке средством идентификации, имеющий код маркировки',
                '32' => 'Товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки, за исключением подакцизного товара',
                '33' => 'Товар, подлежащий маркировке средством идентификации, имеющий код маркировки, за исключением подакцизного товара'
            ]
        ],
        'default' => '1'
    ])
];
