<?php
/**
 * @package       VtbPay Module for ReadyScript
 * @author        ВТБ (ПАО)
 */

namespace VtbPay\Config;

/**
 * Класс предназначен для объявления событий, которые будет прослушивать данный модуль и обработчиков этих событий.
 */
class Handlers extends \RS\Event\HandlerAbstract
{
    function init()
    {
        $this->bind('getlogs')
             ->bind('getroute')
             ->bind('payment.gettypes')
             ->bind('orm.init.catalog-product'); //Сообщаем что у нас появился хук расширяющий товар
    }


    /**
     * Регистрирует в системе классы логирования
     * @param AbstractLog[] $list - список классов логирования
     * @return AbstractLog[]
     */
    public static function getLogs($list)
    {
        $list[] = \VtbPay\Model\Log\VtbLog::getInstance();
        return $list;
    }


    /**
     * Добавляем новые маршруты
     * @param array $routes
     * @return array
     */
    public static function getRoute(array $routes)
    {
        $routes[] = new \RS\Router\Route(
            'vtbpay-front-returns',
            ['/vtbpay/returns/{transactionId}/'],
            null,
            t('Страница возврата пользователя.')
        );

        $routes[] = new \RS\Router\Route(
            'vtbpay-front-webhook',
            ['/vtbpay/webhook/'],
            null,
            t('Вебхук для колбеков платёжной системы.')
        );

        return $routes;
    }


    /**
     * Добавляем новый способ оплаты
     * @param array $list - массив уже существующих типов оплаты
     * @return array
     */
    public static function paymentGetTypes($list)
    {
        $list[] = new \VtbPay\Model\PaymentType\VtbPay();
        return $list;
    }


    /**
     * Расширяем объект товара
     * Внимание на название хука и этой функции . и - не используются
     *
     * @param array $list
     */
    public static function ormInitCatalogProduct(\Catalog\Model\Orm\Product $orm_product)
    {
        //Расширяем поля
       $orm_product->getPropertyIterator()->append(include 'product_form_fields.php');
    }
}
