<?php

namespace Vtbpay\Form\Modifier;

use Symfony\Component\Form\FormBuilderInterface,
    Symfony\Component\Form\Extension\Core\Type\FormType;


final class ProductFormModifier
{
    /**
     * @param int $productId
     * @param FormBuilderInterface $productFormBuilder
     */
    public function modify(
        int $productId,
        FormBuilderInterface $productFormBuilder
    ): void {

        $fields = self::getConfigForm($productId);

        // Добавляем новую вкладку для настроек VTBPAY
        $productFormBuilder->add('vtbpay_settings', FormType::class, [
            'label' => 'Настройки фискализации (Платежная система ВТБ)',
        ]);

        // Получаем вкладку "Настройки фискализации (Платежная система ВТБ)"
        $vtbpaySettingsTabFormBuilder = $productFormBuilder->get('vtbpay_settings');

        foreach ($fields as $name => $field) {
            $vtbpaySettingsTabFormBuilder->add(
                $name,
                $field['type'],
                $field['options']
            );
        }
    }


    /**
     * Возвращает массив с полями настроек фискализации товара.
     *
     * @param int $productId
     * @return array Массив с полями настроек.
     */
    protected static function getConfigForm(int $productId): array
    {
        return include dirname(__DIR__, 3) . '/config/product_config_form.php';
    }
}
