<?php
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

return [
    'VTBPAY_MEASURE_FISCAL' => [
        'type' => ChoiceType::class,
        'options' => [
            'label' => 'Единицы измерения',
            'label_attr' => [
                'title' => 'h2',
                'class' => 'text-info',
            ],
            'choices' => [
                'Выберите опцию' => '-',
                'Применяется для предметов расчета, которые могут быть реализованы поштучно или единицами' => '0',
                'Грамм' => '10',
                'Килограмм' => '11',
                'Тонна' => '12',
                'Сантиметр' => '20',
                'Дециметр' => '21',
                'Метр' => '22',
                'Квадратный сантиметр' => '30',
                'Квадратный дециметр' => '31',
                'Квадратный метр' => '32',
                'Миллилитр' => '40',
                'Литр' => '41',
                'Кубический метр' => '42',
                'Киловатт час' => '50',
                'Гигакалория' => '51',
                'Сутки (день)' => '70',
                'Час' => '71',
                'Минута' => '72',
                'Секунда' => '73',
                'Килобайт' => '80',
                'Мегабайт' => '81',
                'Гигабайт' => '82',
                'Терабайт' => '83',
                'Применяется при использовании иных единиц измерения' => '255'
            ],
            'data' => Configuration::get('VTBPAY_MEASURE_FISCAL_PRODUCT_' . $productId) ?: '-',
            'empty_data' => '-', // default value
            'form_theme' => '@PrestaShop/Admin/TwigTemplateForm/prestashop_ui_kit_base.html.twig',
            'required' => false, // поле не является обязательным
        ],
    ],
    'VTBPAY_TAX_TYPE_FISCAL' => [
        'type' => ChoiceType::class,
        'options' => [
            'label' => 'Ставка налогообложения',
            'label_attr' => [
                'title' => 'h2',
                'class' => 'text-info',
            ],
            'choices' => [
                'Выберите опцию' => '-',
                'Без НДС' => 'none',
                'НДС по ставке 0%' => 'vat0',
                'НДС чека по ставке 10%' => 'vat10',
                'НДС чека по расчетной ставке 10/110' => 'vat110',
                'НДС чека по ставке 20%' => 'vat20',
                'НДС чека по расчетной ставке 20/120' => 'vat120',
                'НДС чека по ставке 5%' => 'vat5',
                'НДС чека по ставке 7%' => 'vat7',
                'НДС чека по расчетной ставке 5/105' => 'vat105',
                'НДС чека по расчетной ставке 7/107' => 'vat107'
            ],
            'data' => Configuration::get('VTBPAY_TAX_TYPE_FISCAL_PRODUCT_' . $productId) ?: '-',
            'empty_data' => '-', // default value
            'form_theme' => '@PrestaShop/Admin/TwigTemplateForm/prestashop_ui_kit_base.html.twig',
            'required' => false, // поле не является обязательным
        ],
    ],
    'VTBPAY_PAYMENT_TYPE_FISCAL' => [
        'type' => ChoiceType::class,
        'options' => [
            'label' => 'Способ расчета',
            'label_attr' => [
                'title' => 'h2',
                'class' => 'text-info',
            ],
            'choices' => [
                'Выберите опцию' => '-',
                'Предоплата 100%' => 'full_prepayment',
                'Предоплата' => 'prepayment',
                'Аванс' => 'advance',
                'Полный расчет' => 'full_payment',
                'Частичный расчет и кредит' => 'partial_payment',
                'Передача в кредит' => 'credit',
                'Оплата кредита' => 'credit_payment'
            ],
            'data' => Configuration::get('VTBPAY_PAYMENT_TYPE_FISCAL_PRODUCT_' . $productId) ?: '-',
            'empty_data' => '-', // default value
            'form_theme' => '@PrestaShop/Admin/TwigTemplateForm/prestashop_ui_kit_base.html.twig',
            'required' => false, // поле не является обязательным
        ],
    ],
    'VTBPAY_PAYMENT_SUBJECT_FISCAL' => [
        'type' => ChoiceType::class,
        'options' => [
            'label' => 'Предмет расчета',
            'label_attr' => [
                'title' => 'h2',
                'class' => 'text-info',
            ],
            'choices' => [
                'Выберите опцию' => '-',
                'Товар' => '1',
                'Подакцизный товар' => '2',
                'Работа' => '3',
                'Услуга' => '4',
                'Ставка азартной игры' => '5',
                'Выигрыш азартной игры' => '6',
                'Ставка лотереи' => '7',
                'Выигрыш лотереи' => '8',
                'Предоставление прав' => '9',
                'Платеж' => '10',
                'Агентское вознаграждение' => '11',
                'Выплата' => '12',
                'Иной предмет расчёта' => '13',
                'Имущественное право' => '14',
                'Внереализационный доход' => '15',
                'Страховые взносы' => '16',
                'Торговый сбор' => '17',
                'Курортный сбор' => '18',
                'Залог' => '19',
                'Расход' => '20',
                'Взносы на ОПС ИП' => '21',
                'Взносы ОПС' => '22',
                'Взносы на ОМС ИП' => '23',
                'Взносы на ОМС' => '24',
                'Взносы на ОСС' => '25',
                'Платеж казино' => '26',
                'Выдача денежных средств банковским платежным агентом' => '27',
                'Подакцизный товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки' => '30',
                'Подакцизный товар, подлежащий маркировке средством идентификации, имеющий код маркировки' => '31',
                'Товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки, за исключением подакцизного товара' => '32',
                'Товар, подлежащий маркировке средством идентификации, имеющий код маркировки, за исключением подакцизного товара' => '33'
            ],
            'data' => Configuration::get('VTBPAY_PAYMENT_SUBJECT_FISCAL_PRODUCT_' . $productId) ?: '-',
            'empty_data' => '-', // default value
            'form_theme' => '@PrestaShop/Admin/TwigTemplateForm/prestashop_ui_kit_base.html.twig',
            'required' => false, // поле не является обязательным
        ],
    ]
];
