<?php
$input = [
    [
        'type' => 'switch',
        'label' => $this->l('Включить тестовый режим'),
        'name' => 'VTBPAY_TEST_MODE',
        'is_bool' => true,
        'desc' => $this->l('В этом режиме оплата за товар не взимается.'),
        'values' => [
            [
                'id' => 'active_on',
                'value' => true,
                'label' => $this->l('Включено')
            ],
            [
                'id' => 'active_off',
                'value' => false,
                'label' => $this->l('Отключено')
            ]
        ],
        'value' => true,
        'priority' => 1
    ],
    [
        'type' => 'text',
        'prefix' => '<i class="icon icon-user"></i>',
        'desc' => $this->l('Введите Client ID'),
        'name' => 'VTBPAY_CLIENT_ID',
        'label' => $this->l('Client ID'),
        'required' => true,
        'priority' => 2
    ],
    [
        'type' => 'text',
        'prefix' => '<i class="icon icon-lock"></i>',
        'desc' => $this->l('Введите Client Secret'),
        'name' => 'VTBPAY_CLIENT_SECRET',
        'label' => $this->l('Client Secret'),
        'required' => true,
        'priority' => 3
    ],
    [
        'type' => 'text',
        'prefix' => '<i class="icon icon-tag"></i>',
        'desc' => $this->l('Введите Merchant-Authorization'),
        'name' => 'VTBPAY_CLIENT_MERCHANT',
        'label' => $this->l('Merchant-Authorization'),
        'priority' => 4
    ],
    [
        'type' => 'switch',
        'label' => $this->l('Включить логирование'),
        'name' => 'VTBPAY_LOGGING',
        'is_bool' => true,
        'desc' => $this->l('Логирование используется для отладки производительности плагина путем сохранения данных запросов к API.'),
        'values' => [
            [
                'id' => 'active_on',
                'value' => true,
                'label' => $this->l('Включено')
            ],
            [
                'id' => 'active_off',
                'value' => false,
                'label' => $this->l('Отключено')
            ]
        ],
        'value' => true,
        'priority' => 5
    ],
    [
        'type' => 'switch',
        'label' => $this->l('Включить двухстадийный платеж'),
        'name' => 'VTBPAY_TWO_STAGE',
        'is_bool' => true,
        'desc' => $this->l('Платеж в 2 этапа: удержание средств после оплаты, затем подтверждение списания или отмена удержания мерчантом через личный кабинет.'),
        'values' => [
            [
                'id' => 'active_on',
                'value' => true,
                'label' => $this->l('Включено')
            ],
            [
                'id' => 'active_off',
                'value' => false,
                'label' => $this->l('Отключено')
            ]
        ],
        'value' => false,
        'priority' => 6
    ],
    [
        'type' => 'text',
        'prefix' => '<i class="icon icon-link"></i>',
        'desc' => $this->l('Ссылка на страницу при успешной оплате (необязательное поле).'),
        'name' => 'VTBPAY_SUCCESSFUL_PAYMENT_PAGE',
        'label' => $this->l('Страница успешной оплаты'),
        'priority' => 7
    ],
    [
        'type' => 'text',
        'prefix' => '<i class="icon icon-link"></i>',
        'desc' => $this->l('Ссылка на страницу при неуспешной оплате (необязательное поле).'),
        'name' => 'VTBPAY_FAILED_PAYMENT_PAGE',
        'label' => $this->l('Страница неудачной оплаты'),
        'priority' => 8
    ],
    [
        'type' => 'html',
        'name' => 'VTBPAY_SEPARATOR',
        'html_content' => '<div class="separator"><h3>' . $this->l('Настройки фискализации') . '</h3></div>',
        'priority' => 9
    ],
    [
        'type' => 'switch',
        'label' => $this->l('Включить фискализацию'),
        'name' => 'VTBPAY_ENABLE_FISCAL',
        'is_bool' => true,
        'desc' => $this->l('Включение и отключение фискализации (поставьте галочку чтобы включить фискализацию).'),
        'values' => [
            [
                'id' => 'active_on',
                'value' => true,
                'label' => $this->l('Включено')
            ],
            [
                'id' => 'active_off',
                'value' => false,
                'label' => $this->l('Отключено')
            ]
        ],
        'value' => true,
        'priority' => 10
    ],
    [
        'type' => 'text',
        'prefix' => '<i class="icon icon-envelope"></i>',
        'desc' => $this->l('Электронная почта для отправки фискального чека, если не указана почта пользователя.'),
        'name' => 'VTBPAY_EMAIL_FISCAL',
        'label' => $this->l('Email'),
        'priority' => 11
    ],
    [
        'type' => 'select',
        'label' => $this->l('Способ расчета для доставки'),
        'name' => 'VTBPAY_PAYMENT_TYPE_DELIVERY_FISCAL',
        'desc' => $this->l('Способ расчета для услуги доставки.'),
        'options' => [
            'query' => [
                [
                    'id' => 'full_prepayment',
                    'name' => $this->l('Предоплата 100%')
                ],
                [
                    'id' => 'prepayment',
                    'name' => $this->l('Предоплата')
                ],
                [
                    'id' => 'advance',
                    'name' => $this->l('Аванс')
                ],
                [
                    'id' => 'full_payment',
                    'name' => $this->l('Полный расчет')
                ],
                [
                    'id' => 'partial_payment',
                    'name' => $this->l('Частичный расчет и кредит')
                ],
                [
                    'id' => 'credit',
                    'name' => $this->l('Передача в кредит')
                ],
                [
                    'id' => 'credit_payment',
                    'name' => $this->l('Оплата кредита')
                ]
            ],
            'id' => 'id',
            'name' => 'name'
        ],
        'priority' => 12
    ],
    [
        'type' => 'html',
        'name' => 'VTBPAY_SEPARATOR_SUBSECTION',
        'html_content' => '<div class="separator"><h3>' . $this->l('Настройки для товаров и услуг по умолчанию') . '</h3></div>',
        'priority' => 13
    ],
    [
        'type' => 'select',
        'label' => $this->l('Единицы измерения'),
        'name' => 'VTBPAY_MEASURE_FISCAL',
        'desc' => $this->l('Единицы измерения количества предмета расчета.'),
        'options' => [
            'query' => [
                [
                    'id' => '0',
                    'name' => $this->l('Применяется для предметов расчета, которые могут быть реализованы поштучно или единицами')
                ],
                [
                    'id' => '10',
                    'name' => $this->l('Грамм')
                ],
                [
                    'id' => '11',
                    'name' => $this->l('Килограмм')
                ],
                [
                    'id' => '12',
                    'name' => $this->l('Тонна')
                ],
                [
                    'id' => '20',
                    'name' => $this->l('Сантиметр')
                ],
                [
                    'id' => '21',
                    'name' => $this->l('Дециметр')
                ],
                [
                    'id' => '22',
                    'name' => $this->l('Метр')
                ],
                [
                    'id' => '30',
                    'name' => $this->l('Квадратный сантиметр')
                ],
                [
                    'id' => '31',
                    'name' => $this->l('Квадратный дециметр')
                ],
                [
                    'id' => '32',
                    'name' => $this->l('Квадратный метр')
                ],
                [
                    'id' => '40',
                    'name' => $this->l('Миллилитр')
                ],
                [
                    'id' => '41',
                    'name' => $this->l('Литр')
                ],
                [
                    'id' => '42',
                    'name' => $this->l('Кубический метр')
                ],
                [
                    'id' => '50',
                    'name' => $this->l('Киловатт час')
                ],
                [
                    'id' => '51',
                    'name' => $this->l('Гигакалория')
                ],
                [
                    'id' => '70',
                    'name' => $this->l('Сутки (день)')
                ],
                [
                    'id' => '71',
                    'name' => $this->l('Час')
                ],
                [
                    'id' => '72',
                    'name' => $this->l('Минута')
                ],
                [
                    'id' => '73',
                    'name' => $this->l('Секунда')
                ],
                [
                    'id' => '80',
                    'name' => $this->l('Килобайт')
                ],
                [
                    'id' => '81',
                    'name' => $this->l('Мегабайт')
                ],
                [
                    'id' => '82',
                    'name' => $this->l('Гигабайт')
                ],
                [
                    'id' => '83',
                    'name' => $this->l('Терабайт')
                ],
                [
                    'id' => '255',
                    'name' => $this->l('Применяется при использовании иных единиц измерения')
                ]
            ],
            'id' => 'id',
            'name' => 'name'
        ],
        'priority' => 14
    ],
    [
        'type' => 'select',
        'label' => $this->l('Ставка налогообложения'),
        'name' => 'VTBPAY_TAX_TYPE_FISCAL',
        'desc' => $this->l('Устанавливает номер налога в ККТ.'),
        'options' => [
            'query' => [
                [
                    'id' => 'none',
                    'name' => $this->l('Без НДС')
                ],
                [
                    'id' => 'vat0',
                    'name' => $this->l('НДС по ставке 0%')
                ],
                [
                    'id' => 'vat10',
                    'name' => $this->l('НДС чека по ставке 10%')
                ],
                [
                    'id' => 'vat110',
                    'name' => $this->l('НДС чека по расчетной ставке 10/110')
                ],
                [
                    'id' => 'vat20',
                    'name' => $this->l('НДС чека по ставке 20%')
                ],
                [
                    'id' => 'vat120',
                    'name' => $this->l('НДС чека по расчетной ставке 20/120')
                ],
                [
                    'id' => 'vat5',
                    'name' => $this->l('НДС чека по ставке 5%')
                ],
                [
                    'id' => 'vat7',
                    'name' => $this->l('НДС чека по ставке 7%')
                ],
                [
                    'id' => 'vat105',
                    'name' => $this->l('НДС чека по расчетной ставке 5/105')
                ],
                [
                    'id' => 'vat107',
                    'name' => $this->l('НДС чека по расчетной ставке 7/107')
                ]
            ],
            'id' => 'id',
            'name' => 'name'
        ],
        'priority' => 15
    ],
    [
        'type' => 'select',
        'label' => $this->l('Способ расчета'),
        'name' => 'VTBPAY_PAYMENT_TYPE_FISCAL',
        'desc' => $this->l('Признак способа расчёта.'),
        'options' => [
            'query' => [
                [
                    'id' => 'full_prepayment',
                    'name' => $this->l('Предоплата 100%')
                ],
                [
                    'id' => 'prepayment',
                    'name' => $this->l('Предоплата')
                ],
                [
                    'id' => 'advance',
                    'name' => $this->l('Аванс')
                ],
                [
                    'id' => 'full_payment',
                    'name' => $this->l('Полный расчет')
                ],
                [
                    'id' => 'partial_payment',
                    'name' => $this->l('Частичный расчет и кредит')
                ],
                [
                    'id' => 'credit',
                    'name' => $this->l('Передача в кредит')
                ],
                [
                    'id' => 'credit_payment',
                    'name' => $this->l('Оплата кредита')
                ]
            ],
            'id' => 'id',
            'name' => 'name'
        ],
        'priority' => 16
    ],
    [
        'type' => 'select',
        'label' => $this->l('Предмет расчета'),
        'name' => 'VTBPAY_PAYMENT_SUBJECT_FISCAL',
        'desc' => $this->l('Признак предмета расчёта.'),
        'options' => [
            'query' => [
                ['id' => '1', 'name' => $this->l('Товар')],
                ['id' => '2', 'name' => $this->l('Подакцизный товар')],
                ['id' => '3', 'name' => $this->l('Работа')],
                ['id' => '4', 'name' => $this->l('Услуга')],
                ['id' => '5', 'name' => $this->l('Ставка азартной игры')],
                ['id' => '6', 'name' => $this->l('Выигрыш азартной игры')],
                ['id' => '7', 'name' => $this->l('Ставка лотереи')],
                ['id' => '8', 'name' => $this->l('Выигрыш лотереи')],
                ['id' => '9', 'name' => $this->l('Предоставление прав')],
                ['id' => '10', 'name' => $this->l('Платеж')],
                ['id' => '11', 'name' => $this->l('Агентское вознаграждение')],
                ['id' => '12', 'name' => $this->l('Выплата')],
                ['id' => '13', 'name' => $this->l('Иной предмет расчёта')],
                ['id' => '14', 'name' => $this->l('Имущественное право')],
                ['id' => '15', 'name' => $this->l('Внереализационный доход')],
                ['id' => '16', 'name' => $this->l('Страховые взносы')],
                ['id' => '17', 'name' => $this->l('Торговый сбор')],
                ['id' => '18', 'name' => $this->l('Курортный сбор')],
                ['id' => '19', 'name' => $this->l('Залог')],
                ['id' => '20', 'name' => $this->l('Расход')],
                ['id' => '21', 'name' => $this->l('Взносы на ОПС ИП')],
                ['id' => '22', 'name' => $this->l('Взносы ОПС')],
                ['id' => '23', 'name' => $this->l('Взносы на ОМС ИП')],
                ['id' => '24', 'name' => $this->l('Взносы на ОМС')],
                ['id' => '25', 'name' => $this->l('Взносы на ОСС')],
                ['id' => '26', 'name' => $this->l('Платеж казино')],
                ['id' => '27', 'name' => $this->l('Выдача денежных средств банковским платежным агентом')],
                ['id' => '30', 'name' => $this->l('Подакцизный товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки')],
                ['id' => '31', 'name' => $this->l('Подакцизный товар, подлежащий маркировке средством идентификации, имеющий код маркировки')],
                ['id' => '32', 'name' => $this->l('Товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки, за исключением подакцизного товара')],
                ['id' => '33', 'name' => $this->l('Товар, подлежащий маркировке средством идентификации, имеющий код маркировки, за исключением подакцизного товара')]
            ],
            'id' => 'id',
            'name' => 'name'
        ],
        'priority' => 17
    ]
];

// Сортируем по priority
uasort($input, function ($a, $b) {
    return ($a['priority'] ?? 10) <=> ($b['priority'] ?? 10);
});

return [
    'form' => [
        'legend' => [
            'title' => $this->l('Настройки'),
            'icon' => 'icon-cogs',
        ],
        'input' => $input,
        'submit' => [
            'title' => $this->l('Сохранить'),
        ],
    ],
];
