<?php
/**
 * PHPShop Module Actions
 *
 * This script defines several action functions for managing a PHPShop module.
 * It handles updating the module version, updating settings, and displaying module configuration.
 *
 * @package VtbPay
 */

$PHPShopOrm = new PHPShopOrm($PHPShopModules->getParam('base.vtbpay.vtbpay_system'));


/**
 * Update the module version
 *
 * This function updates the version of the module.
 *
 * @global object $PHPShopModules The PHPShopModules instance for managing modules.
 * @global object $PHPShopOrm The PHPShopOrm instance for database operations.
 *
 * @return mixed Returns the result of the update action.
 */
function actionBaseUpdate()
{
    global $PHPShopModules, $PHPShopOrm;
    $PHPShopOrm->clean();
    $option = $PHPShopOrm->select();
    $new_version = $PHPShopModules->getUpdate($option['version']);
    $PHPShopOrm->clean();
    $action = $PHPShopOrm->update(['version_new' => $new_version]);
    header('Location: ?path=modules&id='.$_GET['id']);
    return $action;
}


/**
 * Update module settings
 *
 * This function updates the settings of the module.
 *
 * @global object $PHPShopModules The PHPShopModules instance for managing modules.
 * @global object $PHPShopOrm The PHPShopOrm instance for database operations.
 *
 * @return mixed Returns the result of the update action.
 */
function actionUpdate()
{
    global $PHPShopOrm, $PHPShopModules;

    //  
    $PHPShopModules->updateOption($_GET['id'], $_POST['servers']);

    if (empty($_POST['test_mode_new'])) $_POST['test_mode_new'] = 0;
    if (empty($_POST['logging_new'])) $_POST['logging_new'] = 0;
    if (empty($_POST['two_stage_new'])) $_POST['two_stage_new'] = 0;
    if (empty($_POST['enable_fiscal_new'])) $_POST['enable_fiscal_new'] = 0;

    $PHPShopOrm->debug = false;
    $action = $PHPShopOrm->update($_POST);
    header('Location: ?path=modules&id=' . $_GET['id']);

    return $action;
}


/**
 * Display module configuration settings
 *
 * This function displays the configuration settings for the module.
 *
 * @global object $PHPShopGUI The PHPShopGUI instance for handling GUI components.
 * @global object $PHPShopOrm The PHPShopOrm instance for database operations.
 *
 * @return bool Returns true on successful display of the configuration, false otherwise.
 */
function actionStart()
{
    global $PHPShopGUI, $PHPShopOrm;

    PHPShopObj::loadClass('order');

    $PHPShopOrm->objBase = $GLOBALS['SysValue']['base']['vtbpay']['vtbpay_system'];
    $data = $PHPShopOrm->select();

    //    .   text  ,   required
    $Tab1 = $PHPShopGUI->setField('Client ID', $PHPShopGUI->setInput('text.', 'client_id_new', $data['client_id'], false, 300), 1, '  API    .');
    $Tab1 .= $PHPShopGUI->setField('Client Secret', $PHPShopGUI->setInput('text.', 'client_secret_new', $data['client_secret'], false, 300), 1, '  API    .');
    $Tab1 .= $PHPShopGUI->setField('Merchant-Authorization', $PHPShopGUI->setInputText(false, 'merchant_authorization_new', $data['merchant_authorization'], 300), 1, ' ,           .');
    $Tab1 .= $PHPShopGUI->setField('  ', $PHPShopGUI->setCheckbox('test_mode_new', 1, '       .', $data['test_mode']));
    $Tab1 .= $PHPShopGUI->setField(' ', $PHPShopGUI->setCheckbox('logging_new', 1, '           API.', $data['logging']));
    $Tab1 .= $PHPShopGUI->setField('  ', $PHPShopGUI->setCheckbox('two_stage_new', 1, '  2 :    ,          .', $data['two_stage']));
    $Tab1 .= $PHPShopGUI->setField('  ', $PHPShopGUI->setInputText(false, 'btn_text_new', $data['btn_text'], 300));
    $Tab1 .= $PHPShopGUI->setField(' ', $PHPShopGUI->setTextarea('payment_info_new', $data['payment_info']));

    //  
    $Tab1 .= $PHPShopGUI->setField('', '<h4> </h4>');
    $Tab1 .= $PHPShopGUI->setField(' ', $PHPShopGUI->setCheckbox('enable_fiscal_new', 1, '    (    ).', $data['enable_fiscal']));
    $Tab1 .= $PHPShopGUI->setField(' ', $PHPShopGUI->setInputText(false, 'email_fiscal_new', $data['email_fiscal'], 300), 1, '     ,     .');
    $Tab1 .= $PHPShopGUI->setField('   ', $PHPShopGUI->setSelect('payment_type_delivery_fiscal_new', getSettingsOptions($data)['payment_type_delivery_fiscal'], 300,true), 1, '    .');
    $Tab1 .= $PHPShopGUI->setField('', '<h5>      </h5>');
    $Tab1 .= $PHPShopGUI->setField(' ', $PHPShopGUI->setSelect('measure_fiscal_new', getSettingsOptions($data)['measure_fiscal'], 300, true), 1, '    (   ,      ).');
    $Tab1 .= $PHPShopGUI->setField(' ', $PHPShopGUI->setSelect('tax_type_fiscal_new', getSettingsOptions($data)['tax_type_fiscal'], 300, true), 1, '    (   ,      ).');
    $Tab1 .= $PHPShopGUI->setField(' ', $PHPShopGUI->setSelect('payment_type_fiscal_new', getSettingsOptions($data)['payment_type_fiscal'], 300, true), 1, '    (   ,      ).');
    $Tab1 .= $PHPShopGUI->setField(' ', $PHPShopGUI->setSelect('payment_subject_fiscal_new', getSettingsOptions($data)['payment_subject_fiscal'], 300, true), 1, '    (   ,      ).');

    // Registration form
    $Tab3 = $PHPShopGUI->setPay(false, false, $data['version'], false);

    // Build the configuration tabs
    $PHPShopGUI->setTab(
      ['', $Tab1, true],
      [' ', $Tab3]
    );

    // Build the footer content with save and exit buttons
    $ContentFooter =
        $PHPShopGUI->setInput('hidden', 'rowID', $data['id']) .
        $PHPShopGUI->setInput('submit', 'saveID', '', 'right', 80, '', 'but', 'actionUpdate.modules.edit');

    $PHPShopGUI->setFooter($ContentFooter);

    return true;
}


/**
 *   
 *
 * @global string $name The PHPShopGUI instance for handling GUI components.
 * @global array $data The PHPShopOrm instance for database operations.
 *
 * @return array
 */
function getSettingsOptions($data)
{
    return [
        'payment_type_delivery_fiscal' => [
            [' 100%', 'full_prepayment', $data['payment_type_delivery_fiscal']],
            ['', 'prepayment', $data['payment_type_delivery_fiscal']],
            ['', 'advance', $data['payment_type_delivery_fiscal']],
            [' ', 'full_payment', $data['payment_type_delivery_fiscal']],
            ['   ', 'partial_payment', $data['payment_type_delivery_fiscal']],
            ['  ', 'credit', $data['payment_type_delivery_fiscal']],
            [' ', 'credit_payment', $data['payment_type_delivery_fiscal']]
        ],
        'measure_fiscal' => [
            ['   ,       ', '0', $data['measure_fiscal']],
            ['', '10', $data['measure_fiscal']],
            ['', '11', $data['measure_fiscal']],
            ['', '12', $data['measure_fiscal']],
            ['', '20', $data['measure_fiscal']],
            ['', '21', $data['measure_fiscal']],
            ['', '22', $data['measure_fiscal']],
            [' ', '30', $data['measure_fiscal']],
            [' ', '31', $data['measure_fiscal']],
            [' ', '32', $data['measure_fiscal']],
            ['', '40', $data['measure_fiscal']],
            ['', '41', $data['measure_fiscal']],
            [' ', '42', $data['measure_fiscal']],
            [' ', '50', $data['measure_fiscal']],
            ['', '51', $data['measure_fiscal']],
            [' ()', '70', $data['measure_fiscal']],
            ['', '71', $data['measure_fiscal']],
            ['', '72', $data['measure_fiscal']],
            ['', '73', $data['measure_fiscal']],
            ['', '80', $data['measure_fiscal']],
            ['', '81', $data['measure_fiscal']],
            ['', '82', $data['measure_fiscal']],
            ['', '83', $data['measure_fiscal']],
            ['     ', '255', $data['measure_fiscal']]
        ],
        'tax_type_fiscal' => [
            [' ', 'none', $data['tax_type_fiscal']],
            ['   0%', 'vat0', $data['tax_type_fiscal']],
            ['    10%', 'vat10', $data['tax_type_fiscal']],
            ['     10/110', 'vat110', $data['tax_type_fiscal']],
            ['    20%', 'vat20', $data['tax_type_fiscal']],
            ['     20/120', 'vat120', $data['tax_type_fiscal']],
            ['    5%', 'vat5', $data['tax_type_fiscal']],
            ['    7%', 'vat7', $data['tax_type_fiscal']],
            ['     5/105', 'vat105', $data['tax_type_fiscal']],
            ['     7/107', 'vat107', $data['tax_type_fiscal']]
        ],
        'payment_type_fiscal' => [
            [' 100%', 'full_prepayment', $data['payment_type_fiscal']],
            ['', 'prepayment', $data['payment_type_fiscal']],
            ['', 'advance', $data['payment_type_fiscal']],
            [' ', 'full_payment', $data['payment_type_fiscal']],
            ['   ', 'partial_payment', $data['payment_type_fiscal']],
            ['  ', 'credit', $data['payment_type_fiscal']],
            [' ', 'credit_payment', $data['payment_type_fiscal']]
        ],
        'payment_subject_fiscal' => [
            ['', '1', $data['payment_subject_fiscal']],
            [' ', '2', $data['payment_subject_fiscal']],
            ['', '3', $data['payment_subject_fiscal']],
            ['', '4', $data['payment_subject_fiscal']],
            ['  ', '5', $data['payment_subject_fiscal']],
            ['  ', '6', $data['payment_subject_fiscal']],
            [' ', '7', $data['payment_subject_fiscal']],
            [' ', '8', $data['payment_subject_fiscal']],
            [' ', '9', $data['payment_subject_fiscal']],
            ['', '10', $data['payment_subject_fiscal']],
            [' ', '11', $data['payment_subject_fiscal']],
            ['', '12', $data['payment_subject_fiscal']],
            ['  ', '13', $data['payment_subject_fiscal']],
            [' ', '14', $data['payment_subject_fiscal']],
            [' ', '15', $data['payment_subject_fiscal']],
            [' ', '16', $data['payment_subject_fiscal']],
            [' ', '17', $data['payment_subject_fiscal']],
            [' ', '18', $data['payment_subject_fiscal']],
            ['', '19', $data['payment_subject_fiscal']],
            ['', '20', $data['payment_subject_fiscal']],
            ['   ', '21', $data['payment_subject_fiscal']],
            [' ', '22', $data['payment_subject_fiscal']],
            ['   ', '23', $data['payment_subject_fiscal']],
            ['  ', '24', $data['payment_subject_fiscal']],
            ['  ', '25', $data['payment_subject_fiscal']],
            [' ', '26', $data['payment_subject_fiscal']],
            ['     ', '27', $data['payment_subject_fiscal']],
            [' ,    ,    ', '30', $data['payment_subject_fiscal']],
            [' ,    ,   ', '31', $data['payment_subject_fiscal']],
            [',    ,    ,    ', '32', $data['payment_subject_fiscal']],
            [',    ,   ,    ', '33', $data['payment_subject_fiscal']]
        ]
    ];
}

// Handle events
$PHPShopGUI->getAction();

// Display form on start
$PHPShopGUI->setAction($_GET['id'], 'actionStart');
