<?php

namespace Opencart\Catalog\Model\Extension\Vtbpay\Payment;

class Vtbpay extends \Opencart\System\Engine\Model {

		/**
		 * Retrieves the payment methods available for VTB Pay.
		 *
		 * @param array $address (optional) An array containing address data. This parameter is currently not used in the method. Defaults to an empty array.
		 * @return array An array containing the details of the available VTB Pay payment method. If VTB Pay is not available, an empty array is returned.
		 */
		public function getMethods(array $address = []): array {

				$this->load->language('extension/vtbpay/payment/vtbpay');

				$status = false;

				$total = $this->cart->getTotal();
				if ((float)$total >= 0.00) {
						$status = true;
				}

				$method_data = [];

				if ($status) {
						$option_data['vtbpay'] = [
								'code' => 'vtbpay.vtbpay',
								'name' => $this->language->get('heading_title')
						];

						$method_data = [
								'code'       => 'vtbpay',
								'title'      => $this->language->get('heading_title'),
								'name'       => $this->language->get('heading_title'),
								'option'     => $option_data,
								'sort_order' => $this->config->get('payment_vtbpay_sort_order'),
						];
				}

				return $method_data;
		}
}
