(function ($) {
    $(document).ready(function () {
        const prefix = '#input-payment-vtbpay-'; // Префикс для идентификаторов полей
        const requiredFields = ['login-atol-fiscal', 'pass-atol-fiscal', 'kkt-atol-fiscal', 'inn-atol-fiscal'];
        const elements = {
            testMode1: $(prefix + 'test-mode'),
            testMode2: $(prefix + 'test-mode-atol-fiscal'),
            fiscalDropdown: $(prefix + 'ofd-fiscal'),
            checkboxesWithPostfix: $('input[id$="-atol-fiscal"], select[id$="-atol-fiscal"]'),
        };

        // Управление обязательностью полей
        function toggleRequiredFields(isRequired) {
            requiredFields.forEach(field => {
                const fieldElement = $(prefix + field);
                fieldElement.closest('.row').toggleClass('required', isRequired);
            });
        }

        // Скрытие/показ полей
        function toggleFieldVisibility(isVisible) {
            elements.checkboxesWithPostfix.each(function () {
                $(this).closest('.row').toggle(isVisible);
            });
        }

        // Проверка тестового режима
        function validateTestMode() {
            const isChecked1 = elements.testMode1.is(':checked');
            const isChecked2 = elements.testMode2.is(':checked');

            if (isChecked1 ^ isChecked2) { // XOR: один включен, другой нет
                alert('Обратите внимание, что тестовый режим включен только для одной из интеграций.');
            }
        }

        // Управление полями на основе выбора OFD
        function handleDropdownChange() {
            const isAtolSelected = elements.fiscalDropdown.val() === 'atol';
            toggleRequiredFields(isAtolSelected);
            toggleFieldVisibility(isAtolSelected);
        }

        // Инициализация
        elements.fiscalDropdown.on('change', handleDropdownChange);
        $('button[type="submit"][form="form-payment"]').on('click', function () {
            if (elements.fiscalDropdown.val() === 'atol') validateTestMode();
        });

        // Первоначальная настройка
        handleDropdownChange();
    });
})(jQuery);
