<?php

namespace Opencart\Admin\Controller\Extension\Vtbpay\Event;

class Vtbpay extends \Opencart\System\Engine\Controller
{

    /**
     * getSettingsFields method
     *
     * Получение настроек в форме продукта.
     *
     * @return array
     */
    private function getSettingsFields()
    {
        return [
            'measure_fiscal' => [
                'type' => 'select',
                'title' => $this->language->get('entry_measure_fiscal'),
                'default' => '-',
                'options' => [
                    '-' => $this->language->get('option_select_option'),
                    '0' => $this->language->get('option_piece_unit'),
                    '10' => $this->language->get('option_gram'),
                    '11' => $this->language->get('option_kilogram'),
                    '12' => $this->language->get('option_ton'),
                    '20' => $this->language->get('option_centimeter'),
                    '21' => $this->language->get('option_decimeter'),
                    '22' => $this->language->get('option_meter'),
                    '30' => $this->language->get('option_sq_cm'),
                    '31' => $this->language->get('option_sq_dm'),
                    '32' => $this->language->get('option_sq_m'),
                    '40' => $this->language->get('option_ml'),
                    '41' => $this->language->get('option_liter'),
                    '42' => $this->language->get('option_cubic_m'),
                    '50' => $this->language->get('option_kwh'),
                    '51' => $this->language->get('option_gcal'),
                    '70' => $this->language->get('option_day'),
                    '71' => $this->language->get('option_hour'),
                    '72' => $this->language->get('option_minute'),
                    '73' => $this->language->get('option_second'),
                    '80' => $this->language->get('option_kb'),
                    '81' => $this->language->get('option_mb'),
                    '82' => $this->language->get('option_gb'),
                    '83' => $this->language->get('option_tb'),
                    '255' => $this->language->get('option_other_units')
                ]
            ],
            'tax_type_fiscal' => [
                'type' => 'select',
                'title' => $this->language->get('entry_tax_type_fiscal'),
                'default' => '-',
                'options' => [
                    '-' => $this->language->get('option_select_option'),
                    'none' => $this->language->get('option_no_vat'),
                    'vat0' => $this->language->get('option_vat0'),
                    'vat10' => $this->language->get('option_vat10'),
                    'vat110' => $this->language->get('option_vat110'),
                    'vat20' => $this->language->get('option_vat20'),
                    'vat120' => $this->language->get('option_vat120'),
                    'vat5' => $this->language->get('option_vat5'),
                    'vat7' => $this->language->get('option_vat7'),
                    'vat105' => $this->language->get('option_vat105'),
                    'vat107' => $this->language->get('option_vat107')
                ]
            ],
            'payment_type_fiscal' => [
                'type' => 'select',
                'title' => $this->language->get('entry_payment_type_fiscal'),
                'default' => '-',
                'options' => [
                    '-' => $this->language->get('option_select_option'),
                    'full_prepayment' => $this->language->get('option_full_prepayment'),
                    'prepayment' => $this->language->get('option_prepayment'),
                    'advance' => $this->language->get('option_advance'),
                    'full_payment' => $this->language->get('option_full_payment'),
                    'partial_payment' => $this->language->get('option_partial_payment'),
                    'credit' => $this->language->get('option_credit'),
                    'credit_payment' => $this->language->get('option_credit_payment')
                ]
            ],
            'payment_subject_fiscal' => [
                'type' => 'select',
                'title' => $this->language->get('entry_payment_subject_fiscal'),
                'default' => '-',
                'options' => [
                    '-' => $this->language->get('option_select_option'),
                    '1' => $this->language->get('option_goods'),
                    '2' => $this->language->get('option_excise_goods'),
                    '3' => $this->language->get('option_work'),
                    '4' => $this->language->get('option_service'),
                    '5' => $this->language->get('option_gambling_bet'),
                    '6' => $this->language->get('option_gambling_win'),
                    '7' => $this->language->get('option_lottery_bet'),
                    '8' => $this->language->get('option_lottery_win'),
                    '9' => $this->language->get('option_rights'),
                    '10' => $this->language->get('option_payment'),
                    '11' => $this->language->get('option_agency_fee'),
                    '12' => $this->language->get('option_payout'),
                    '13' => $this->language->get('option_other_subject'),
                    '14' => $this->language->get('option_property_right'),
                    '15' => $this->language->get('option_non_operating_income'),
                    '16' => $this->language->get('option_insurance_contributions'),
                    '17' => $this->language->get('option_trade_fee'),
                    '18' => $this->language->get('option_resort_fee'),
                    '19' => $this->language->get('option_deposit'),
                    '20' => $this->language->get('option_expense'),
                    '21' => $this->language->get('option_pension_ip'),
                    '22' => $this->language->get('option_pension'),
                    '23' => $this->language->get('option_health_ip'),
                    '24' => $this->language->get('option_health'),
                    '25' => $this->language->get('option_social'),
                    '26' => $this->language->get('option_casino_payment'),
                    '27' => $this->language->get('option_cash_issuance_bank_agent'),
                    '30' => $this->language->get('option_excise_goods_no_code'),
                    '31' => $this->language->get('option_excise_goods_with_code'),
                    '32' => $this->language->get('option_goods_no_code'),
                    '33' => $this->language->get('option_goods_with_code')
                ]
            ]
        ];
    }


    /**
     * Обработка события отображения формы продукта.
     *
     * @param string $route Маршрут, по которому было вызвано событие.
     * @param array $args Аргументы, переданные в событие.
     *
     * @param string $output HTML-код выходного результата.
     */
    public function onProductForm(
        string &$route,
        array &$args,
        string &$output
    ) {
        $this->load->language('extension/vtbpay/payment/vtbpay');
        $this->load->model('catalog/product');

        // Загрузка данных продукта
        $product = $this->model_catalog_product->getProduct($args['product_id'] ?? '');

        // Получение опций
        $fields = $this->getSettingsFields();

        foreach ($fields as $field => $field_data) {
            $data['settings']['payment_vtbpay_' . $field] = $field_data;
            if ($field_data['type'] === 'separator') continue;
            $data['settings']['payment_vtbpay_' . $field]['value'] = $product['payment_vtbpay_' . $field] ?? '-';
        }

        // Вставка данных в форму продукта
        $output = str_replace(
            '<li class="nav-item"><a href="#tab-report" data-bs-toggle="tab" class="nav-link">',
            $this->load->view('extension/vtbpay/event/ul_product_form', []) . '<li class="nav-item"><a href="#tab-report" data-bs-toggle="tab" class="nav-link">',
            $output
        );

        $output = str_replace(
            '<div id="tab-report" class="tab-pane">',
            $this->load->view('extension/vtbpay/event/tab_product_form', $data) . '<div id="tab-report" class="tab-pane">',
            $output
        );
    }


    /**
     * Обновление данных о продукте с дополнительными полями VtbPay.
     *
     * @param array $data Данные из запроса.
     * @param int $product_id ID продукта.
     *
     * @return void
     */
    private function updateProductFiscalData(array $data, int $product_id): void
    {
        $fields = [
            'payment_vtbpay_measure_fiscal',
            'payment_vtbpay_tax_type_fiscal',
            'payment_vtbpay_payment_type_fiscal',
            'payment_vtbpay_payment_subject_fiscal'
        ];

        foreach ($fields as $field) {
            if (isset($data[$field])) {
                $this->db->query("UPDATE " . DB_PREFIX . "product SET $field = '" . $this->db->escape($data[$field]) . "' WHERE product_id = '" . (int) $product_id . "'");
            }
        }
    }


    /**
     * Обработка события добавления продукта.
     *
     * @param string $route Маршрут, по которому было вызвано событие.
     * @param array $args Аргументы, переданные в событие.
     * @param mixed $output Результат выполнения основного действия.
     *
     * @return void
     */
    public function onAddProduct(
        string &$route,
        array &$args,
        mixed &$output
    ): void {
        // Получение данных из запроса
        $data = $this->request->post;
        // Обновление данных о продукте
        $this->updateProductFiscalData(
            $data,
            (int) $output
        );
    }


    /**
     * Обработка события редактирования продукта.
     *
     * @param string $route Маршрут, по которому было вызвано событие.
     * @param array $args Аргументы, переданные в событие.
     * @param mixed $output Результат выполнения основного действия.
     *
     * @return void
     */
    public function onEditProduct(
        string &$route,
        array &$args,
        mixed &$output
    ): void {
        // Получение данных из запроса
        $data = $this->request->post;
        $product_id = $args[0];  // Получение ID продукта из аргументов
        // Обновление данных о продукте
        $this->updateProductFiscalData(
            $data,
            (int) $product_id
        );
    }
}
