<?php

/**
 * Class ModelExtensionPaymentVtbpay
 * This class models the VTB payment extension. 
 * It includes a method to get the payment method based on given address and total amount.
 */
class ModelExtensionPaymentVtbpay extends Model 
{
	
		/**
		 * getMethod method
		 *
		 * This method retrieves the payment method if the total is more than 0.
		 * It loads the VTB payment language file and checks if the total amount is more than 0.
		 * If it's more than 0, it sets the status as true and prepares the method data
		 * including the code, title, terms, and sort order of the VTB payment.
		 * If the total is 0 or less, the status is set as false and the method data remains as an empty array.
		 *
		 * @param array $address An array containing the address information.
		 * @param float $total The total amount for the transaction.
		 * @return array The method data including code, title, terms, and sort order for VTB payment, or an empty array if total is 0 or less.
		 */
		public function getMethod($address, $total) 
		{
				$this->load->language('extension/payment/vtbpay');

				$status = false;
				
				if ((float)$total > 0.00) {
						$status = true;
				}

				$method_data = [];

				if ($status) {
						$method_data = [
								'code'       => 'vtbpay',
								'title'      => $this->language->get('heading_title'),
								'terms'      => '',
								'sort_order' => $this->config->get('payment_vtbpay_sort_order')
						];
				}

				return $method_data;
		}
}