(function ($) {
    $(document).ready(function () {
        const prefix = '#input-payment_vtbpay_'; // Префикс для идентификаторов полей
        const requiredFields = ['login_atol_fiscal', 'pass_atol_fiscal', 'kkt_atol_fiscal', 'inn_atol_fiscal'];
        const elements = {
            testMode1: $(prefix + 'test_mode'),
            testMode2: $(prefix + 'test_mode_atol_fiscal'),
            fiscalDropdown: $(prefix + 'ofd_fiscal'),
            checkboxesWithPostfix: $('input[id$="_atol_fiscal"], select[id$="_atol_fiscal"]'),
        };

        // Управление обязательностью полей
        function toggleRequiredFields(isRequired) {
            requiredFields.forEach(field => {
                const fieldElement = $(prefix + field);
                fieldElement.prop('required', isRequired).closest('.form-group').toggleClass('required', isRequired);
            });
        }

        // Скрытие/показ полей
        function toggleFieldVisibility(isVisible) {
            elements.checkboxesWithPostfix.each(function () {
                $(this).closest('.form-group').toggle(isVisible);
            });
        }

        // Проверка тестового режима
        function validateTestMode() {
            const isChecked1 = elements.testMode1.is(':checked');
            const isChecked2 = elements.testMode2.is(':checked');

            if (isChecked1 ^ isChecked2) { // XOR: один включен, другой нет
                alert('Обратите внимание, что тестовый режим включен только для одной из интеграций.');
            }
        }

        // Управление полями на основе выбора OFD
        function handleDropdownChange() {
            const isAtolSelected = elements.fiscalDropdown.val() === 'atol';
            toggleRequiredFields(isAtolSelected);
            toggleFieldVisibility(isAtolSelected);
        }

        // Инициализация
        elements.fiscalDropdown.on('change', handleDropdownChange);
        $('button[type="submit"][form="form-payment"]').on('click', function () {
            if (elements.fiscalDropdown.val() === 'atol') validateTestMode();
        });

        // Первоначальная настройка
        handleDropdownChange();
    });
})(jQuery);
