<?php
class ModelExtensionPaymentVtbpay extends Model {
    /**
     * Массив столбцов, которые нужно добавить или удалить.
     *
     * @var string[]
     */
    private array $columns = [
        'payment_vtbpay_measure_fiscal',
        'payment_vtbpay_tax_type_fiscal',
        'payment_vtbpay_payment_type_fiscal',
        'payment_vtbpay_payment_subject_fiscal'
    ];

    /**
     * Выполняет установку модуля, добавляя необходимые столбцы в таблицу.
     *
     * @return void
     */
    public function install(): void {
        foreach ($this->columns as $column) {
            $this->alterTable(DB_PREFIX . 'product', $column, 'ADD');
        }
    }

    /**
     * Выполняет удаление модуля, удаляя столбцы из таблицы.
     *
     * @return void
     */
    public function uninstall(): void {
        foreach ($this->columns as $column) {
            $this->alterTable(DB_PREFIX . 'product', $column, 'DROP');
        }
    }

    /**
     * Добавляет или удаляет столбец в указанной таблице в зависимости от действия.
     *
     * @param string $table Название таблицы
     * @param string $column Название столбца
     * @param string $action Действие ('ADD' или 'DROP')
     * @return void
     */
    private function alterTable(string $table, string $column, string $action): void {
        if ($action === 'ADD') {
            if (!$this->columnExists($table, $column)) {
                $this->db->query("ALTER TABLE `" . $table . "` ADD `$column` VARCHAR(255) DEFAULT NULL;");
            }
        } elseif ($action === 'DROP') {
            if ($this->columnExists($table, $column)) {
                $this->db->query("ALTER TABLE `" . $table . "` DROP COLUMN `$column`;");
            }
        }
    }

    /**
     * Проверяет, существует ли столбец в указанной таблице.
     *
     * @param string $table Название таблицы
     * @param string $columnName Название столбца
     * @return bool Возвращает true, если столбец существует, иначе false
     */
    private function columnExists(string $table, string $columnName): bool {
        $query = $this->db->query("SHOW COLUMNS FROM `" . $table . "` LIKE '" . $this->db->escape($columnName) . "'");
        return $query->num_rows > 0;
    }
}
