<?php
/*
  Plugin Name: Платежная система ВТБ
  Description: Плагин для оплаты через платежную систему ВТБ.
  Author: VTB
  Version: 1.3.6
  Edition: PAYMENT
 */

new VtbPayPayment;

class VtbPayPayment
{
    /**
     * The name of the plugin.
     * @var string $pluginName
     */
    private static $pluginName = 'vtbpay-payment';

    /**
     * The path for the plugin, used to locate the plugin's directory.
     * @var string $path
     */
    private static $path = '';

    /**
     * Language of the engine locale.
     * @var array $lang
     */
    private static $lang;


    /**
     * Constructor Method
     *
     * This method is called when the class is instantiated. It sets
     * up the activation and deactivation of the plugin, the path
     * for the plugin, and calls the methods for setting the payment
     * button and handling payment results.
     */
    public function __construct()
    {
        self::$lang = PM::plugLocales(self::$pluginName);

        mgActivateThisPlugin(__FILE__, [__CLASS__, 'activate']);
        mgDeactivateThisPlugin(__FILE__, [__CLASS__, 'deactivate']);

        self::$path = PLUGIN_DIR . self::$pluginName;

        self::setPaymentBtn();

        self::setPaymentResult();
    }


    /**
     * setPaymentBtn Method
     *
     * This method sets up the payment button. If the current page
     * section is 'order' and the necessary POST or GET variables
     * are set, it saves the necessary data in the session and
     * echoes the payment data in a hidden div.
     */
    static function setPaymentBtn()
    {
        $vtbpayPluginId = self::getPaymentForPlugin();

        if (URL::isSection('order')) {
            // I don’t know why the checks are so terrible, but it doesn’t work any other way.
            if (
                isset($_POST['payment']) && $_POST['payment'] ||
                isset($_POST['paymentId']) && $_POST['paymentId'] ||
                isset($_GET['addOrderOk']) && $_GET['addOrderOk'] ||
                isset($_GET['orderId']) && $_GET['orderId']
            ) {
                // Check GET
                if (isset($_GET['orderId'])) $_SESSION['orderId'] = $_GET['orderId'] ?: null;
                if (isset($_GET['paymentId'])) $_SESSION['paymentId'] = $_GET['paymentId'] ?: null;

                // Check POST
                if (isset($_POST['orderId'])) $_SESSION['orderId'] = $_POST['orderId'] ?: null;
                if (
                    isset($_POST['payment']) ||
                    isset($_POST['paymentId'])
                ) $_SESSION['paymentId'] = ($_POST['payment'] ?: $_POST['paymentId']) ?: null;

                echo "<div class=\"payment-data\" style=\"display: none\">
                      <span id=\"payment-id\">{$_SESSION['paymentId']}</span>
                      <span id=\"order-id\">{$_SESSION['orderId']}</span>
                      <span id=\"vtbpay_id\">{$vtbpayPluginId}</span></div>";

                mgAddMeta('<script src="' . SITE . '/' . self::$path . '/js/vtbpay-script.js"></script>');
            }
        }
    }


    /**
     * setPaymentResult Method
     *
     * This method handles the result of the payment. If the current
     * page section is 'payment' and the 'pay' GET variable is set,
     * it retrieves the order information from the database and
     * displays a success or failure message accordingly.
     */
    static function setPaymentResult()
    {
        if (URL::isSection('payment')) {
            if (
                isset($_GET['pay']) &&
                $_GET['plugin_name'] === self::$pluginName
            ) {
                $msg = '';

                if ($_GET['pay'] == 'success') {
                    $order_id = $_GET['orderId'];
                    $order = new Models_Order();
                    $orderInfo = $order->getOrder("id = {$order_id}");

                    if ($orderInfo[$order_id]['paided'] == 1) {
                        $msg = self::$lang['VTBPAY_SUCCESSFULLY_PAID_ORDER'] . ' № ' . $orderInfo[$order_id]['number'];
                    }
                }
                elseif ($_GET['pay'] == 'fail') {
                    $msg = self::$lang['VTBPAY_UNSUCCESSFULLY_PAID_ORDER'];
                }

                if (!empty($msg)) {
                    // If you insert a response only through js, then the message is cached.
                    echo "<div class=\"payment-data\" style=\"display: none\">
                        <span id=\"payment-result-message\"><strong>{$msg}</strong></span></div>";

                    mgAddMeta(
                        '<script>
                            var payment_result_message = $(\'#payment-result-message\').text();
                            $(\'.c-alert\').html(payment_result_message);
                        </script>'
                    );
                }
            }
        }
    }


    /**
     * activate Method
     *
     * This method is called when the plugin is activated. It checks
     * if the payment plugin is already set up, and if not, sets it
     * up by calling setPaymentForPlugin.
     */
    static function activate()
    {
        // Checking PHP Version
        if (version_compare(PHP_VERSION, '7.4.0', '<')) {
            die(self::$lang['VTBPAY_REQUIRED_PHP_VERSION']);
        }

        $currentPayment = Models_Payment::getPaymentByPlugin(self::$pluginName);
        if (!$currentPayment) {
            $name = 'VtbPay';

            $icon = '/mg-plugins/'.self::$pluginName.'/src/icon.png';

            $defaultParams = self::getConfigForm();

            $urls = [
                 [
                    'type' => 'success',
                    'title' => 'Success URL',
                    'link' => '/payment?payStatus=success',
                 ],
                [
                    'type' => 'fail',
                    'title' => 'Fail URL',
                    'link' => '/payment?payStatus=fail',
                ],
            ];

            Models_Payment::addPayment(
                self::$pluginName,
                $name,
                $name,
                self::$pluginName,
                $defaultParams,
                $icon,
                0,
                $urls
            );
        }

        $prfx = PREFIX;

        $tableSql = "CREATE TABLE IF NOT EXISTS {$prfx}vtbpay_transactions (
					id INT(15) NOT NULL,
					transaction_id VARCHAR(40) NOT NULL,
					date TIMESTAMP DEFAULT CURRENT_TIMESTAMP
				);";
        DB::query($tableSql);
    }


    /**
     * Возвращает массив с полями настроек.
     *
     * @return array Массив с полями настроек.
     */
    protected static function getConfigForm()
    {
        return include 'config/config_form.php';
    }


    /**
     * deactivate Method
     *
     * This method is called when the plugin is deactivated. It checks
     * if the payment plugin is set up, and if so, removes it by
     * calling removePaymentForPlugin.
     */
    static function deactivate()
    {
        $paymentId = self::getPaymentForPlugin();

        if ($paymentId) {
            self::removePaymentForPlugin();
        }
    }


    /**
     * removePaymentForPlugin Method
     *
     * This method removes the payment plugin from the database.
     * It removes the corresponding table and record from the
     * payment table.
     */
    static function removePaymentForPlugin()
    {
        $name = 'VtbPay';
        $prfx = PREFIX;

        DB::query("DROP TABLE `{$prfx}vtbpay_transactions`");

        DB::query("DELETE FROM `{$prfx}payment`
									 WHERE `name` = " . DB::quote($name));
    }


    /**
     * getPaymentForPlugin Method
     *
     * This method checks if the payment plugin is set up by querying
     * the database. If the plugin is set up, it returns the plugin's
     * id. Otherwise, it returns false.
     */
    static function getPaymentForPlugin()
    {
        $name = 'VtbPay';
        $prfx = PREFIX;

        $dbRes = DB::query("SELECT id
										        FROM `{$prfx}payment`
										        WHERE `name` = '{$name}'");
        if ($result = DB::fetchAssoc($dbRes)) {
            $sql = "UPDATE `{$prfx}payment`
				          SET `activity` = 1
				          WHERE `name` = '{$name}'";
            if (DB::query($sql)) return $result['id'];
        }
        return false;
    }
}

?>
