define(
    [
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/action/place-order',
        'Magento_Checkout/js/action/select-payment-method',
        'Magento_Customer/js/model/customer',
        'Magento_Checkout/js/checkout-data',
        'Magento_Checkout/js/model/payment/additional-validators',
        'Magento_Checkout/js/model/error-processor',
        'Magento_Checkout/js/model/full-screen-loader',
        'mage/translate',
        'mage/url',
        'Magento_Ui/js/model/messageList'
    ],
    function (
        $,
        Component,
        placeOrderAction,
        selectPaymentMethodAction,
        customer,
        checkoutData,
        additionalValidators,
        errorProcessor,
        fullScreenLoader,
        $t,
        url,
        globalMessageList
    ) {
        'use strict';

        return Component.extend({
            redirectAfterPlaceOrder: false,
            defaults: {
                template: 'Vtb_VtbPay/payment/vtbpay'
            },
            
            /**
             * Fetches and returns the instructions for the payment method from the checkout configuration.
             *
             * @return {*} The instructions for the payment method.
             */
            getInstructions: function () {
                return window.checkoutConfig.payment.instructions[this.item.method];
            },

            /**
             * Initiates the placement of the order.
             * 
             * @param {Object} data - The form data.
             * @param {Event} event - The form submission event.
             * @return {boolean} Whether or not the order placement was successful.
             */
            placeOrder: function (data, event) {
                if (event)
                    event.preventDefault();
                var self = this,
                    placeOrder,
                    emailValidationResult = customer.isLoggedIn(),
                    loginFormSelector = 'form[data-role=email-with-possible-login]';
                if (!customer.isLoggedIn()) {
                    $(loginFormSelector).validation();
                    emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());
                }
                if (emailValidationResult && this.validate()) {
                    this.isPlaceOrderActionAllowed(false);
                    placeOrder = placeOrderAction(this.getData(), false, this.messageContainer);

                    $.when(placeOrder).done(function () {
                        self.isPlaceOrderActionAllowed(true);
                    }).done(this.afterPlaceOrder.bind(this));
                    return true;
                }
                return false;
            },

            /**
             * Selects the current payment method.
             *
             * @return {boolean} Always returns true.
             */
            selectPaymentMethod: function () {
                selectPaymentMethodAction(this.getData());
                checkoutData.setSelectedPaymentMethod(this.item.method);
                return true;
            },

            /**
             * Executes after an order has been placed. Initiates the payment redirect.
             */
            afterPlaceOrder: function () {
                fullScreenLoader.startLoader();
                $.post(url.build('vtbpay/payment/redirect'), 'json')
                    .done(data => {
                        window.location = data.url;
                    }).fail(response => {
                    console.log(this.messageContainer);
                    errorProcessor.process('error', this.messageContainer);
                }).always(() => {
                    fullScreenLoader.stopLoader();
                });
            }
        });
    }
);