<?php

namespace Vtb\VtbPay\Setup;

use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * Класс InstallData для установки данных модуля Vtb\VtbPay
 */
class InstallData implements InstallDataInterface
{
    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    /**
     * Конструктор
     *
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(EavSetupFactory $eavSetupFactory)
    {
        $this->eavSetupFactory = $eavSetupFactory;
    }


    /**
     * Устанавливает поля фискализации на страницах редактирования товаров
     *
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);

        $attributes = [
            'fiscal_measure' => [
                'type' => 'varchar',
                'label' => 'Units of measurement',
                'input' => 'select',
                'source' => 'Vtb\VtbPay\Model\Config\Source\MeasureSource',
                'required' => false,
                'sort_order' => 12,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
                'group' => 'Fiscalization settings (VTB Payment System)',
            ],
            'fiscal_tax' => [
                'type' => 'varchar',
                'label' => 'The tax rate',
                'input' => 'select',
                'source' => 'Vtb\VtbPay\Model\Config\Source\TaxSource',
                'required' => false,
                'sort_order' => 13,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
                'group' => 'Fiscalization settings (VTB Payment System)',
            ],
            'fiscal_payment_method' => [
                'type' => 'varchar',
                'label' => 'Calculation method',
                'input' => 'select',
                'source' => 'Vtb\VtbPay\Model\Config\Source\PaymentSource',
                'required' => false,
                'sort_order' => 14,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
                'group' => 'Fiscalization settings (VTB Payment System)',
            ],
            'fiscal_subject' => [
                'type' => 'varchar',
                'label' => 'The subject of the calculation',
                'input' => 'select',
                'source' => 'Vtb\VtbPay\Model\Config\Source\SubjectSource',
                'required' => false,
                'sort_order' => 15,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
                'group' => 'Fiscalization settings (VTB Payment System)',
            ],
        ];

        foreach ($attributes as $attributeCode => $attributeData) {
            $eavSetup->removeAttribute(
                \Magento\Catalog\Model\Product::ENTITY,
                'payment_vtbpay_' . $attributeCode
            );
            $eavSetup->addAttribute(
                \Magento\Catalog\Model\Product::ENTITY,
                'payment_vtbpay_' . $attributeCode,
                $attributeData
            );
        }

        $setup->endSetup();
    }
}
