<?php
namespace Vtb\VtbPay\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface,
    Vtb\VtbPay\Model\VtbPay,
    Vtb\VtbPay\Logger\Logger,
    Vtb\VtbPay\Gateway\Http\Client\Exception\VtbPayException,
    Vtb\VtbPay\Gateway\Http\Client\Common\VtbPayLogger as MainVtbPayLogger,
    Symfony\Component\Dotenv\Dotenv;


/**
 * Class VtbPayLogger
 *
 * This class provides a logging mechanism for the VTB payment module.
 * It checks if the logging is enabled via configuration in the admin panel and logs the events accordingly.
 * The class uses the custom Logger object to perform the actual logging operation.
 * The logging message is constructed with the provided class name, message, and context information.
 *
 * @package Vtb\VtbPay\Helper
 */
class VtbPayLogger
{
    /**
     * @var Logger
     */
    protected $_logger;

    /**
     * @var MainVtbPayLogger
     */
    public $logger;

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;


    /**
     * VtbPayLogger constructor.
     *
     * @param Logger $logger
     * @param Json $json
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
      Logger $logger,
      ScopeConfigInterface $scopeConfig
    ) {
        $this->_logger = $logger;
        $this->scopeConfig = $scopeConfig;

        $env_path = dirname(__DIR__) . '/config/.env';
        if (file_exists($env_path)) (new Dotenv())->load($env_path);

        $this->setVtbpayLogger();
    }


    /**
     * Инициализация и настройка объекта класса VtbPayLogger.
     *
     * Эта функция инициализирует и настраивает логгер, используемый плагином VtbPay для ведения журнала.
     *
     * @return void
     */
    private function setVtbpayLogger(): void
    {
        $logging = $this->scopeConfig->getValue(
            VtbPay::PAYMENT_METHOD_VTBPAY_XML_PATH . 'payment_vtbpay_logging',
            ScopeConfigInterface::SCOPE_TYPE_DEFAULT
        );
        $sensitive_data_keys = json_decode($_ENV['LOG_SENSITIVE_DATA_KEYS'] ?? '', true) ?: [];
        $this->logger = MainVtbPayLogger::getInstance()
                        ->setOption('showCurrentDate', false)
                        ->setOption('showLogLevel', false)
                        ->setOption('showBacktrace', true)
                        ->setOption('sensitiveDataKeys', $sensitive_data_keys)
                        ->setCustomRecording(function($message) use ($logging) {
                            if ($logging) $this->_logger->debug($message);
                        }, MainVtbPayLogger::LOG_LEVEL_DEBUG)
                        ->setCustomRecording(function($message) {
                            $this->_logger->error($message);
                        }, MainVtbPayLogger::LOG_LEVEL_ERROR);
    }
}
