// Общая функция для создания ComboBox
let createComboBox = function(name, hiddenName, data) {
    let ComboBoxConstructor = function(config) {
        config = config || {};

        const store = new Ext.data.SimpleStore({
            fields: ['key', 'caption'],
            data: data
        });

        Ext.applyIf(config, {
            store: store,
            name: name,
            hiddenName: hiddenName,
            displayField: 'caption',
            valueField: 'key',
            mode: 'local',
            triggerAction: 'all',
            editable: false,
            selectOnFocus: false,
            preventRender: true
        });

        ComboBoxConstructor.superclass.constructor.call(this, config);
    };

    Ext.extend(ComboBoxConstructor, MODx.combo.ComboBox);
    Ext.reg(name, ComboBoxConstructor);
};

// Способ расчета
createComboBox(
    'vtbpay_payment_type_fiscal',
    'vtbpay_payment_type_fiscal',
    [
        ['full_prepayment', 'Предоплата 100%'],
        ['prepayment', 'Предоплата'],
        ['advance', 'Аванс'],
        ['full_payment', 'Полный расчет'],
        ['partial_payment', 'Частичный расчет и кредит'],
        ['credit', 'Передача в кредит'],
        ['credit_payment', 'Оплата кредита']
    ]
);

// Единица измерения
createComboBox(
    'vtbpay_measure_fiscal',
    'vtbpay_measure_fiscal',
    [
        ['0', 'Применяется для предметов расчета, которые могут быть реализованы поштучно или единицами'],
        ['10', 'Грамм'],
        ['11', 'Килограмм'],
        ['12', 'Тонна'],
        ['20', 'Сантиметр'],
        ['21', 'Дециметр'],
        ['22', 'Метр'],
        ['30', 'Квадратный сантиметр'],
        ['31', 'Квадратный дециметр'],
        ['32', 'Квадратный метр'],
        ['40', 'Миллилитр'],
        ['41', 'Литр'],
        ['42', 'Кубический метр'],
        ['50', 'Киловатт час'],
        ['51', 'Гигакалория'],
        ['70', 'Сутки (день)'],
        ['71', 'Час'],
        ['72', 'Минута'],
        ['73', 'Секунда'],
        ['80', 'Килобайт'],
        ['81', 'Мегабайт'],
        ['82', 'Гигабайт'],
        ['83', 'Терабайт'],
        ['255', 'Применяется при использовании иных единиц измерения']
    ]
);

// Налоговая ставка
createComboBox(
    'vtbpay_tax_type_fiscal',
    'vtbpay_tax_type_fiscal',
    [
        ['none', 'Без НДС'],
        ['vat0', 'НДС по ставке 0%'],
        ['vat10', 'НДС чека по ставке 10%'],
        ['vat110', 'НДС чека по расчетной ставке 10/110'],
        ['vat20', 'НДС чека по ставке 20%'],
        ['vat120', 'НДС чека по расчетной ставке 20/120'],
        ['vat5', 'НДС чека по ставке 5%'],
        ['vat7', 'НДС чека по ставке 7%'],
        ['vat105', 'НДС чека по расчетной ставке 5/105'],
        ['vat107', 'НДС чека по расчетной ставке 7/107']
    ]
);

// Предмет расчета
createComboBox(
    'vtbpay_payment_subject_fiscal',
    'vtbpay_payment_subject_fiscal',
    [
        ['1', 'Товар'],
        ['2', 'Подакцизный товар'],
        ['3', 'Работа'],
        ['4', 'Услуга'],
        ['5', 'Ставка азартной игры'],
        ['6', 'Выигрыш азартной игры'],
        ['7', 'Ставка лотереи'],
        ['8', 'Выигрыш лотереи'],
        ['9', 'Предоставление прав'],
        ['10', 'Платеж'],
        ['11', 'Агентское вознаграждение'],
        ['12', 'Выплата'],
        ['13', 'Иной предмет расчёта'],
        ['14', 'Имущественное право'],
        ['15', 'Внереализационный доход'],
        ['16', 'Страховые взносы'],
        ['17', 'Торговый сбор'],
        ['18', 'Курортный сбор'],
        ['19', 'Залог'],
        ['20', 'Расход'],
        ['21', 'Взносы на ОПС ИП'],
        ['22', 'Взносы ОПС'],
        ['23', 'Взносы на ОМС ИП'],
        ['24', 'Взносы на ОМС'],
        ['25', 'Взносы на ОСС'],
        ['26', 'Платеж казино'],
        ['27', 'Выдача денежных средств банковским платежным агентом'],
        ['30', 'Подакцизный товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки'],
        ['31', 'Подакцизный товар, подлежащий маркировке средством идентификации, имеющий код маркировки'],
        ['32', 'Товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки, за исключением подакцизного товара'],
        ['33', 'Товар, подлежащий маркировке средством идентификации, имеющий код маркировки, за исключением подакцизного товара']
    ]
);
