<?php

/**
 * Loads system settings into build
 * @var modX $modx
 * @package mspVtbPay
 * @subpackage build
 */
$settings = [];

$configPrefix = 'ms2_payment_vtbpay_';

$tmp = [
    'client_id' => [
        'value' => '',
        'xtype' => 'textfield',
        'area' => 'ms2_payment',
    ],
    'client_secret' => [
        'value' => '',
        'xtype' => 'textfield',
        'area' => 'ms2_payment',
    ],
    'merchant_authorization' => [
        'value' => '',
        'xtype' => 'textfield',
        'area' => 'ms2_payment',
    ],
    'test_mode' => [
        'value' => false,
        'xtype' => 'combo-boolean',
        'area' => 'ms2_payment',
    ],
    'logging' => [
        'value' => false,
        'xtype' => 'combo-boolean',
        'area' => 'ms2_payment',
    ],
    'two_stage' => [
        'value' => false,
        'xtype' => 'combo-boolean',
        'area' => 'ms2_payment',
    ],
    'success_id' => [
        'xtype' => 'numberfield',
        'value' => 0,
        'area' => 'ms2_payment',
    ],
    'failure_id' => [
        'xtype' => 'numberfield',
        'value' => 0,
        'area' => 'ms2_payment',
    ],
    'enable_fiscal' => [
        'value' => false,
        'xtype' => 'combo-boolean',
        'area' => 'ms2_payment',
    ],
    'email_fiscal' => [
        'value' => '',
        'xtype' => 'textfield',
        'area' => 'ms2_payment',
    ],
    'payment_type_delivery_fiscal' => [
        'value' => 'full_prepayment',
        'xtype' => 'vtbpay_payment_type_fiscal',
        'area' => 'ms2_payment',
    ],
    'measure_fiscal' => [
        'value' => '0',
        'xtype' => 'vtbpay_measure_fiscal',
        'area' => 'ms2_payment',
    ],
    'tax_type_fiscal' => [
        'value' => 'none',
        'xtype' => 'vtbpay_tax_type_fiscal',
        'area' => 'ms2_payment',
    ],
    'payment_type_fiscal' => [
        'value' => 'full_prepayment',
        'xtype' => 'vtbpay_payment_type_fiscal',
        'area' => 'ms2_payment',
    ],
    'payment_subject_fiscal' => [
        'value' => '1',
        'xtype' => 'vtbpay_payment_subject_fiscal',
        'area' => 'ms2_payment',
    ]
];

foreach ($tmp as $k => $v) {
    /* @var modSystemSetting $setting */
    $setting = $modx->newObject(modSystemSetting::class);
    $setting->fromArray(array_merge(
        [
            'key' => $configPrefix . $k,
            'namespace' => 'minishop2',
            'editedon' => date('Y-m-d H:i:s'),
        ],
        $v
    ), '', true, true);

    $settings[] = $setting;
}

unset($tmp);
return $settings;
