jQuery().ready(function ($) {
	const prefix = '#pm_params_vtbpay_'; // Префикс для идентификаторов полей
	const requiredFields = ['login_atol_fiscal', 'pass_atol_fiscal', 'kkt_atol_fiscal', 'inn_atol_fiscal'];
	const elements = {
			testMode1: $(prefix + 'test_mode0'),
			testMode2: $(prefix + 'test_mode_atol_fiscal0'),
			fiscalDropdown: $(prefix + 'ofd_fiscal'),
			checkboxesWithPostfix: $('input[id$="_atol_fiscal"], input[id$="_atol_fiscal0"], select[id$="_atol_fiscal"]'),
	};

	// Управление обязательностью полей
	function toggleRequiredFields(isRequired) {
	    requiredFields.forEach(field => {
	        const fieldElement = $(prefix + field);
					fieldElement.prop('required', isRequired);

	        const controlGroup = fieldElement.closest('tr'); // Найти родителя с классом 'control-group'
	        if (controlGroup.length) {
	            const labelElement = controlGroup.find('td.key'); // Найти label с нужным 'for' атрибутом
	            labelElement.append(
									(isRequired && !labelElement.find('span.text-danger').length) ? '<span class="text-danger">*<span>' : ''
							);
	        }
	    });
	}

	// Скрытие/показ полей
	function toggleFieldVisibility(isVisible) {
			elements.checkboxesWithPostfix.each(function () {
					$(this).closest('tr').toggle(isVisible);
			});
	}

	// Проверка тестового режима
	function validateTestMode() {
			const isChecked1 = elements.testMode1.is(':checked');
			const isChecked2 = elements.testMode2.is(':checked');

			if (isChecked1 ^ isChecked2) { // XOR: один включен, другой нет
					alert('Обратите внимание, что тестовый режим включен только для одной из интеграций.');
			}
	}

	// Управление полями на основе выбора OFD
	function handleDropdownChange() {
			const isAtolSelected = elements.fiscalDropdown.val() === 'atol';
			toggleRequiredFields(isAtolSelected);
			toggleFieldVisibility(isAtolSelected);
	}

	// Инициализация
	elements.fiscalDropdown.on('change', handleDropdownChange);
	// Первоначальная настройка
	handleDropdownChange();


	Joomla.submitbutton = function(a){
		form = document.getElementById('adminForm');
		var requiredField = form.querySelectorAll('[required]');
		var isValidate = true;
		[].forEach.call(requiredField, function(elm) {
			if (!$(elm).val()) {
				form.reportValidity();
				isValidate = false;
			}
		});

		if (elements.fiscalDropdown.val() === 'atol') validateTestMode();

		if (isValidate) {
			form.task.value = a;
			form.submit();
		}

		return false;
	};
});
