<?php
$form_fields =  [
    'client_id' => [
        '#title' => 'Client ID',
        '#description' => 'Для вызова API требуется идентификатор клиента продавца.',
        '#default_value' => $this->configuration['client_id'] ?? '',
        '#type' => 'textfield',
        '#required' => true,
    ],
    'client_secret' => [
        '#title' => 'Client Secret',
        '#description' => 'Для вызова API требуется секретный ключ продавца.',
        '#default_value' => $this->configuration['client_secret'] ?? '',
        '#type' => 'textfield',
        '#required' => true,
    ],
    'merchant_authorization' => [
        '#title' => 'Merchant-Authorization',
        '#description' => 'Заголовок запроса, используемый ресурсом мерчанта для дополнительной аутентификации при доступе к платежному шлюзу.',
        '#default_value' => $this->configuration['merchant_authorization'] ?? '',
        '#type' => 'textfield',
    ],
    'logging' => [
        '#title' => 'Логирование',
        '#description' => 'Логирование используется для отладки производительности плагина путем сохранения данных запросов к API.',
        '#default_value' => $this->configuration['logging'] ?? false,
        '#type' => 'radios',
        '#options' =>  [
            true => 'Включено',
            false => 'Выключено'
        ]
    ],
    'two_stage' => [
        '#title' => 'Двустадийный платеж',
        '#description' => 'Платеж в 2 этапа: удержание средств после оплаты, затем подтверждение списания или отмена удержания мерчантом через личный кабинет.',
        '#default_value' => $this->configuration['two_stage'] ?? false,
        '#type' => 'radios',
        '#options' =>  [
            true => 'Включено',
            false => 'Выключено'
        ]
    ]
];

if (
    isset($_ENV['SHOW_RETURN_URL_FIELD']) &&
    $_ENV['SHOW_RETURN_URL_FIELD'] === '1'
) {
    $form_fields += [
        'return_url' => [
            '#title' => 'Относительный URL возврата после оплаты (без домена)',
            '#description' => 'Страница для возврата после оплаты с подключённым на ней платёжным обработчиком. Используйте #ID# там, где нужно подставить идентификатор заказа.',
            '#default_value' => $this->configuration['return_url'] ?? '',
            '#type' => 'textfield'
        ]
    ];
}


/**
 * Поля настроек фискализации
 */
$form_fields += [
    'enable_fiscal' => [
        '#title' => 'Включить фискализацию',
        '#description' => 'Включение и отключение фискализации (поставьте галочку чтобы включить фискализацию).',
        '#default_value' => $this->configuration['enable_fiscal'] ?? false,
        '#type' => 'radios',
        '#options' =>  [
            true => 'Включено',
            false => 'Выключено'
        ]
    ],
    'ofd_fiscal' => [
        '#title' => 'Операторы фискальных данных',
        '#description' => 'Выберите оператора фискальных данных.',
        '#default_value' => $this->configuration['ofd_fiscal'] ?? '1ofd',
        '#type' => 'select',
        '#options' => [
            '1ofd' => 'Первый ОФД',
            'atol' => 'АТОЛ ФФД 1.2 (v5)',
            'orange_data' => 'Orange Data ФФД 1.05'
        ],
    ],
    // Настройки фискализации только для АТОЛ
    'test_mode_atol_fiscal' => [
        '#title' => 'Тестовый режим АТОЛ Онлайн',
        '#description' => 'Включение тестового режима АТОЛ Онлайн.',
        '#default_value' => $this->configuration['test_mode_atol_fiscal'] ?? false,
        '#type' => 'radios',
        '#options' =>  [
            true => 'Включено',
            false => 'Выключено'
        ]
    ],
    'login_atol_fiscal' => [
        '#title' => 'Логин',
        '#description' => 'Логин в АТОЛ Онлайн.',
        '#default_value' => $this->configuration['login_atol_fiscal'] ?? '',
        '#type' => 'textfield',
    ],
    'pass_atol_fiscal' => [
        '#title' => 'Пароль',
        '#description' => 'Пароль в АТОЛ Онлайн.',
        '#default_value' => $this->configuration['pass_atol_fiscal'] ?? '',
        '#type' => 'textfield',
    ],
    'kkt_atol_fiscal' => [
        '#title' => 'Код группы',
        '#description' => 'Идентификатор группы ККТ в АТОЛ Онлайн.',
        '#default_value' => $this->configuration['kkt_atol_fiscal'] ?? '',
        '#type' => 'textfield',
    ],
    'inn_atol_fiscal' => [
        '#title' => 'ИНН',
        '#description' => 'ИНН организации.',
        '#default_value' => $this->configuration['inn_atol_fiscal'] ?? '',
        '#type' => 'textfield',
    ],
    'tax_system_atol_fiscal' => [
        '#title' => 'Система налогообложения',
        '#description' => 'Система налогообложения вашей компании.',
        '#default_value' => $this->configuration['tax_system_atol_fiscal'] ?? 'osn',
        '#type' => 'select',
        '#options' => [
            'osn' => 'Общая СН',
            'usn_income' => 'Упрощенная СН (доходы)',
            'usn_income_outcome' => 'Упрощенная СН (доходы минус расходы)',
            'envd' => 'Единый налог на вмененный доход',
            'esn' => 'Единый сельскохозяйственный налог',
            'patent' => 'Патентная СН'
        ],
    ],
    // Настройки фискализации только для Orange Data
    'test_mode_orange_data_fiscal' => [
        '#title' => 'Тестовый режим Orange Data',
        '#description' => 'Включение тестового режима Orange Data.',
        '#default_value' => $this->configuration['test_mode_orange_data_fiscal'] ?? false,
        '#type' => 'radios',
        '#options' =>  [
            true => 'Включено',
            false => 'Выключено'
        ]
    ],
    'signature_key_orange_data_fiscal' => [
        '#title' => 'Ключ для проверки подписи',
        '#description' => 'Название ключа, который должен быть использован для проверки подписи.',
        '#default_value' => $this->configuration['signature_key_orange_data_fiscal'] ?? '',
        '#type' => 'textfield',
    ],
    'private_key_orange_data_fiscal' => [
        '#type' => 'managed_file',
        '#title' => 'Private key',
        '#description' => 'Закрытый ключ пользователя для подписания запросов.',
        '#upload_location' => 'private://commerce_vtbpayment_cert/',
        '#default_value' => $this->configuration['private_key_orange_data_fiscal'] ?? NULL,
        '#upload_validators' => [
            'file_validate_extensions' => ['pem'],
        ]
    ],
    'client_key_orange_data_fiscal' => [
        '#type' => 'managed_file',
        '#title' => 'Client Key',
        '#description' => 'Закрытый ключ клиента для подключения SSL.',
        '#upload_location' => 'private://commerce_vtbpayment_cert/',
        '#default_value' => $this->configuration['client_key_orange_data_fiscal'] ?? NULL,
        '#upload_validators' => [
            'file_validate_extensions' => ['key'],
        ]
    ],
    'client_crt_orange_data_fiscal' => [
        '#type' => 'managed_file',
        '#title' => 'Client Certificate',
        '#description' => 'Сертификат клиента (подписанный закрытым ключом, соответствующим корневому сертификату client_ca.crt).',
        '#upload_location' => 'private://commerce_vtbpayment_cert/',
        '#default_value' => $this->configuration['client_crt_orange_data_fiscal'] ?? NULL,
        '#upload_validators' => [
            'file_validate_extensions' => ['crt'],
        ]
    ],
    'ca_cert_orange_data_fiscal' => [
        '#type' => 'managed_file',
        '#title' => 'CA Certificate',
        '#description' => 'Orangedata root certificate (with public key inside). All certificates of all clients are signed with the private key corresponding to this certificate.',
        '#upload_location' => 'private://commerce_vtbpayment_cert/',
        '#default_value' => $this->configuration['ca_cert_orange_data_fiscal'] ?? NULL,
        '#upload_validators' => [
            'file_validate_extensions' => ['pem'],
        ]
    ],
    'cert_password_orange_data_fiscal' => [
        '#title' => 'Пароль сертификата',
        '#description' => 'Пароль сертификата SSL.',
        '#default_value' => $this->configuration['cert_password_orange_data_fiscal'] ?? '',
        '#type' => 'textfield',
    ],
    'group_orange_data_fiscal' => [
        '#title' => 'Код группы',
        '#description' => 'Группа устройств, с помощью которых будет пробит чек.',
        '#default_value' => $this->configuration['group_orange_data_fiscal'] ?? 'Main',
        '#type' => 'textfield',
    ],
    'inn_orange_data_fiscal' => [
        '#title' => 'ИНН',
        '#description' => 'ИНН организации.',
        '#default_value' => $this->configuration['inn_orange_data_fiscal'] ?? '',
        '#type' => 'textfield',
    ],
    'tax_system_orange_data_fiscal' => [
        '#title' => 'Система налогообложения',
        '#description' => 'Система налогообложения вашей компании.',
        '#default_value' => $this->configuration['tax_system_orange_data_fiscal'] ?? '0',
        '#type' => 'select',
        '#options' => [
            '0' => 'Общая СН',
            '1' => 'Упрощенная СН (доходы)',
            '2' => 'Упрощенная СН (доходы минус расходы)',
            '3' => 'Единый налог на вмененный доход',
            '4' => 'Единый сельскохозяйственный налог',
            '5' => 'Патентная СН'
        ],
    ],
    // Общие настройки фискализации
    'email_fiscal' => [
        '#title' => 'Электронная почта',
        '#description' => 'Электронная почта для отправки фискального чека, если не указана почта пользователя.',
        '#default_value' => $this->configuration['email_fiscal'] ?? '',
        '#type' => 'textfield',
    ],
    'payment_type_delivery_fiscal' => [
        '#title' => 'Способ расчета для доставки',
        '#description' => 'Способ расчета для услуги доставки.',
        '#default_value' => $this->configuration['payment_type_delivery_fiscal'] ?? 'full_prepayment',
        '#type' => 'select',
        '#options' => [
            'full_prepayment' => 'Предоплата 100%',
            'prepayment' => 'Предоплата',
            'advance' => 'Аванс',
            'full_payment' => 'Полный расчет',
            'partial_payment' => 'Частичный расчет и кредит',
            'credit' => 'Передача в кредит',
            'credit_payment' => 'Оплата кредита'
        ],
    ],
    'measure_fiscal' => [
        '#title' => 'Единицы измерения',
        '#description' => 'Единицы измерения по умолчанию (для товаров и услуг, у которых не указана единица измерения).',
        '#default_value' => $this->configuration['measure_fiscal'] ?? 0,
        '#type' => 'select',
        '#options' => [
            0 => 'Применяется для предметов расчета, которые могут быть реализованы поштучно или единицами',
            10 => 'Грамм',
            11 => 'Килограмм',
            12 => 'Тонна',
            20 => 'Сантиметр',
            21 => 'Дециметр',
            22 => 'Метр',
            30 => 'Квадратный сантиметр',
            31 => 'Квадратный дециметр',
            32 => 'Квадратный метр',
            40 => 'Миллилитр',
            41 => 'Литр',
            42 => 'Кубический метр',
            50 => 'Киловатт час',
            51 => 'Гигакалория',
            70 => 'Сутки (день)',
            71 => 'Час',
            72 => 'Минута',
            73 => 'Секунда',
            80 => 'Килобайт',
            81 => 'Мегабайт',
            82 => 'Гигабайт',
            83 => 'Терабайт',
            255 => 'Применяется при использовании иных единиц измерения'
        ],
    ],
    'tax_type_fiscal' => [
        '#title' => 'Налоговая ставка',
        '#description' => 'Ставка налогообложения по умолчанию (для товаров и услуг, у которых не указана ставка налогообложения).',
        '#default_value' => $this->configuration['tax_type_fiscal'] ?? 'none',
        '#type' => 'select',
        '#options' => [
            'none' => 'Без НДС',
            'vat0' => 'НДС по ставке 0%',
            'vat10' => 'НДС чека по ставке 10%',
            'vat110' => 'НДС чека по расчетной ставке 10/110',
            'vat20' => 'НДС чека по ставке 20%',
            'vat120' => 'НДС чека по расчетной ставке 20/120',
            'vat5' => 'НДС чека по ставке 5%',
            'vat7' => 'НДС чека по ставке 7%',
            'vat105' => 'НДС чека по расчетной ставке 5/105',
            'vat107' => 'НДС чека по расчетной ставке 7/107'
        ],
    ],
    'payment_type_fiscal' => [
        '#title' => 'Способ расчета',
        '#description' => 'Способ расчета по умолчанию (для товаров и услуг, у которых не указан способ расчета).',
        '#default_value' => $this->configuration['payment_type_fiscal'] ?? 'full_prepayment',
        '#type' => 'select',
        '#options' => [
            'full_prepayment' => 'Предоплата 100%',
            'prepayment' => 'Предоплата',
            'advance' => 'Аванс',
            'full_payment' => 'Полный расчет',
            'partial_payment' => 'Частичный расчет и кредит',
            'credit' => 'Передача в кредит',
            'credit_payment' => 'Оплата кредита'
        ],
    ],
    'payment_subject_fiscal' => [
        '#title' => 'Предмет расчета',
        '#description' => 'Предмет расчета по умолчанию (для товаров и услуг, у которых не указан предмет расчета).',
        '#default_value' => $this->configuration['payment_subject_fiscal'] ?? 1,
        '#type' => 'select',
        '#options' => [
            1 => 'Товар',
            2 => 'Подакцизный товар',
            3 => 'Работа',
            4 => 'Услуга',
            5 => 'Ставка азартной игры',
            6 => 'Выигрыш азартной игры',
            7 => 'Ставка лотереи',
            8 => 'Выигрыш лотереи',
            9 => 'Предоставление прав',
            10 => 'Платеж',
            11 => 'Агентское вознаграждение',
            12 => 'Выплата',
            13 => 'Иной предмет расчёта',
            14 => 'Имущественное право',
            15 => 'Внереализационный доход',
            16 => 'Страховые взносы',
            17 => 'Торговый сбор',
            18 => 'Курортный сбор',
            19 => 'Залог',
            20 => 'Расход',
            21 => 'Взносы на ОПС ИП',
            22 => 'Взносы ОПС',
            23 => 'Взносы на ОМС ИП',
            24 => 'Взносы на ОМС',
            25 => 'Взносы на ОСС',
            26 => 'Платеж казино',
            27 => 'Выдача денежных средств банковским платежным агентом',
            30 => 'Подакцизный товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки',
            31 => 'Подакцизный товар, подлежащий маркировке средством идентификации, имеющий код маркировки',
            32 => 'Товар, подлежащий маркировке средством идентификации, не имеющий кода маркировки, за исключением подакцизного товара',
            33 => 'Товар, подлежащий маркировке средством идентификации, имеющий код маркировки, за исключением подакцизного товара'
        ]
    ]
];

return $form_fields;
