<?php
// Preventing direct access to the script, because it must be included by the "include" directive.
defined('BOOTSTRAP') or die('Access denied');

/**
 * Install the VtbPayments payment processor.
 *
 * This function is responsible for installing the VtbPayments payment processor. It defines the processor data,
 * checks if the processor exists, and either inserts a new processor entry or updates an existing one in the
 * payment_processors table.
 */
function fn_vtbpayments_install()
{
    $processor_data = [
        'processor' => 'Платежная система ВТБ',
        'processor_script' => 'vtbpayments.php',
        'processor_template' => 'views/orders/components/payments/cc_outside.tpl',
        'admin_template' => 'vtbpayments.tpl',
        'callback' => 'Y',
        'type' => 'P',
        'position' => 10,
        'addon' => 'vtbpayments',
    ];

    $processor_id = db_get_field(
        'SELECT processor_id FROM ?:payment_processors WHERE admin_template = ?s',
        $processor_data['admin_template']
    );

    if (empty($processor_id)) {
        db_query('INSERT INTO ?:payment_processors ?e', $processor_data);
    } else {
        db_query('UPDATE ?:payment_processors SET ?u WHERE processor_id = ?i', $processor_data, $processor_id);
    }

    // Список столбцов для добавления
    $columns_to_add = [
        'measure_fiscal',
        'tax_type_fiscal',
        'payment_type_fiscal',
        'payment_subject_fiscal'
    ];
    foreach ($columns_to_add as $column) {
        // Добавление столбца
        db_query("ALTER TABLE `?:products` ADD `{$column}` varchar(255) NOT NULL DEFAULT ''");
    }
}


/**
 * Uninstall the VtbPayments payment processor.
 *
 * This function is responsible for uninstalling the VtbPayments payment processor. It retrieves payment IDs
 * associated with the processor's admin_template, deletes those payments, removes the processor entry from
 * payment_processors, and sets processor IDs in payments to 0 and status to 'D' if applicable.
 */
function fn_vtbpayments_uninstall()
{
    $admin_tpl = 'vtbpayments.tpl';

    $payment_ids = db_get_fields(
        'SELECT a.payment_id FROM ?:payments AS a
        LEFT JOIN ?:payment_processors AS b ON a.processor_id = b.processor_id
        WHERE b.admin_template = ?s',
        $admin_tpl
    );
    foreach ($payment_ids as $payment_id) {
        fn_delete_payment($payment_id);
    }
    db_query('DELETE FROM ?:payment_processors WHERE admin_template = ?s', $admin_tpl);

    $processor_id = db_get_field('SELECT processor_id FROM ?:payment_processors WHERE admin_template = ?s', $admin_tpl);
    if (!empty($processor_id)) {
        db_query('UPDATE ?:payments SET processor_id = 0, status = "D" WHERE processor_id = ?i', $processor_id);
    }

    // Список столбцов для удаления
    $columns_to_remove = [
        'measure_fiscal',
        'tax_type_fiscal',
        'payment_type_fiscal',
        'payment_subject_fiscal'
    ];
    foreach ($columns_to_remove as $column) {
        db_query("ALTER TABLE `?:products` DROP COLUMN `{$column}`");
    }
}


/**
 * Get vtbpayments processor params
 *
 * @return array|string
 */
function fn_vtbpayments_get_product_settings_fiscal($product_id)
{
    $product_settings_fiscal = db_get_row('SELECT `measure_fiscal`, `tax_type_fiscal`, `payment_type_fiscal`, `payment_subject_fiscal` FROM ?:products WHERE product_id = ?i', $product_id);

    return $product_settings_fiscal ?: [];
}
